<?php
/*
 * @copyright Copyright (c) 2023 AltumCode (https://altumcode.com/)
 *
 * This software is exclusively sold through https://altumcode.com/ by the AltumCode author.
 * Downloading this product from any other sources and running it without a proper license is illegal,
 *  except the official ones linked from https://altumcode.com/.
 */

return [
    'admin_blog.menu' => 'Blog',
    'admin_blog.main.advanced' => 'Advanced settings',
    'admin_blog.main.title' => 'Title',
    'admin_blog.main.keywords' => 'Meta keywords',
    'admin_blog.main.keywords_help' => 'Comma separated keywords (keyword1, keyword2..etc)',
    'admin_blog.main.image' => 'Featured image',
    'admin_blog.main.order_help' => 'Easily arrange pages with numbers in ascending order.',
    'admin_blog.main.blog_posts_category_id' => 'Category',
    'admin_blog.main.blog_posts_category_id_null' => 'No category',
    'admin_blog.main.editor' => 'Editor',
    'admin_blog.main.editor_raw' => 'No editor',
    'admin_blog.main.editor_wysiwyg' => 'WYSIWYG',
    'admin_blog.main.editor_blocks' => 'Blocks',
    'admin_blog.main.editor_confirm' => 'By switching the editor, you may lose your already existing content.',
    'admin_blog.main.content' => 'Content',
    'admin_blog.main.is_published' => 'Is published',
    'admin_blog.error_message.url_exists' => 'This URL alias is already taken.',
    'admin_blog.warning_message.disabled' => 'The blog system is currently disabled. Enable it from the %sWebsite settings page%s.',


    'admin_blog_posts.breadcrumb' => 'Blog posts',
    'admin_blog_posts.title' => 'Blog posts',
    'admin_blog_posts.menu' => 'Posts',
    'admin_blog_posts.header' => 'Blog posts',
    'admin_blog_posts.header_no_data' => 'Create your first blog post',
    'admin_blog_posts.subheader_no_data' => 'Create informational, helpful and quality content for your users.',
    'admin_blog_posts.create' => 'Create post',
    'admin_blog_posts.total_views' => '%s views',
    'admin_blog_posts.table.blog_post' => 'Post',


    'admin_blog_post_create.breadcrumb' => 'Create blog post',
    'admin_blog_post_create.title' => 'Create blog post',
    'admin_blog_post_create.header' => 'Create blog post',


    'admin_blog_post_update.breadcrumb' => 'Edit blog post',
    'admin_blog_post_update.title' => 'Edit blog post',
    'admin_blog_post_update.header' => 'Edit blog post',


    'admin_blog_posts_categories.breadcrumb' => 'Blog posts categories',
    'admin_blog_posts_categories.title' => 'Blog posts categories',
    'admin_blog_posts_categories.menu' => 'Categories',
    'admin_blog_posts_categories.header' => 'Blog posts categories',
    'admin_blog_posts_categories.header_no_data' => 'Create your first blog posts category',
    'admin_blog_posts_categories.subheader_no_data' => 'Separate and categorize your blog posts easily.',
    'admin_blog_posts_categories.create' => 'Create category',
    'admin_blog_posts_categories.table.blog_posts_category' => 'Category',
    'admin_blog_posts_categories.table.blog_posts' => 'View blog posts',


    'admin_blog_posts_category_create.breadcrumb' => 'Create category',
    'admin_blog_posts_category_create.title' => 'Create category',
    'admin_blog_posts_category_create.header' => 'Create category',


    'admin_blog_posts_category_update.breadcrumb' => 'Edit category',
    'admin_blog_posts_category_update.title' => 'Edit category',
    'admin_blog_posts_category_update.header' => 'Edit category',


    'admin_resources.menu' => 'Resources',
    'admin_resources.main.advanced' => 'Advanced settings',
    'admin_resources.main.title' => 'Title',
    'admin_resources.main.keywords' => 'Meta keywords',
    'admin_resources.main.keywords_help' => 'Comma separated keywords (keyword1, keyword2..etc)',
    'admin_resources.main.open_in_new_tab' => 'Open in new tab',
    'admin_resources.main.editor' => 'Editor',
    'admin_resources.main.editor_raw' => 'No editor',
    'admin_resources.main.editor_wysiwyg' => 'WYSIWYG',
    'admin_resources.main.editor_blocks' => 'Blocks',
    'admin_resources.main.editor_confirm' => 'By switching the editor, you may lose your already existing content.',
    'admin_resources.main.content' => 'Content',
    'admin_resources.main.position' => 'Position',
    'admin_resources.main.position_top' => 'Top menu',
    'admin_resources.main.position_bottom' => 'Bottom menu',
    'admin_resources.main.position_hidden' => 'Hidden',
    'admin_resources.main.type_internal' => 'Page',
    'admin_resources.main.type_external' => 'Link',
    'admin_resources.main.pages_category_id' => 'Category',
    'admin_resources.main.pages_category_id_null' => 'No category',
    'admin_resources.main.order_help' => 'Easily arrange with numbers in ascending order.',
    'admin_resources.main.is_published' => 'Is published',
    'admin_resources.error_message.url_exists' => 'This URL alias is already taken.',
    'admin_resources.warning_message.disabled' => 'The pages system is currently disabled. Enable it from the %sWebsite settings page%s.',


    'admin_pages.breadcrumb' => 'Pages',
    'admin_pages.title' => 'Pages',
    'admin_pages.menu' => 'Pages',
    'admin_pages.header' => 'Pages',
    'admin_pages.header_no_data' => 'Create your first page',
    'admin_pages.subheader_no_data' => 'Create additional pages that you can attach to the platform with ease.',
    'admin_pages.create' => 'Create page',
    'admin_pages.table.page' => 'Page',
    'admin_pages.table.total_views' => '%s views',


    'admin_page_create.breadcrumb' => 'Create page',
    'admin_page_create.title' => 'Create page',
    'admin_page_create.header' => 'Create page',


    'admin_page_update.breadcrumb' => 'Edit page',
    'admin_page_update.title' => 'Edit page',
    'admin_page_update.header' => 'Edit page',


    'admin_pages_categories.breadcrumb' => 'Pages categories',
    'admin_pages_categories.menu' => 'Categories',
    'admin_pages_categories.title' => 'Pages categories',
    'admin_pages_categories.header' => 'Pages categories',
    'admin_pages_categories.header_no_data' => 'Create your first page category',
    'admin_pages_categories.subheader_no_data' => 'Sort your additional pages by categories.',
    'admin_pages_categories.create' => 'Create category',
    'admin_pages_categories.table.pages_category' => 'Category',
    'admin_pages_categories.table.pages' => 'View pages',


    'admin_pages_category_create.breadcrumb' => 'Create pages category',
    'admin_pages_category_create.title' => 'Create pages category',
    'admin_pages_category_create.header' => 'Create a new pages category',


    'admin_pages_category_update.breadcrumb' => 'Edit pages category',
    'admin_pages_category_update.title' => 'Edit pages category',
    'admin_pages_category_update.header' => 'Edit pages category',


    'admin_plans.breadcrumb' => 'Plans',
    'admin_plans.title' => 'Plans',
    'admin_plans.menu' => 'Plans',
    'admin_plans.header' => 'Plans',
    'admin_plans.create' => 'Create plan',

    'admin_plans.table.name' => 'Plan Name',
    'admin_plans.table.custom_help' => 'Custom plans can be defined directly from the User Edit page.',
    'admin_plans.table.price' => 'Price',
    'admin_plans.table.monthly' => 'Monthly',
    'admin_plans.table.annual' => 'Annual',
    'admin_plans.table.lifetime' => 'Lifetime',
    'admin_plans.table.users' => 'Users',

    'admin_plans.main.plan_id' => 'Plan ID',
    'admin_plans.main.price' => 'Price',
    'admin_plans.main.custom_contact_value' => 'Contact button value',
    'admin_plans.main.custom_button_url' => 'Contact button URL',
    'admin_plans.main.monthly_price' => 'Monthly Price',
    'admin_plans.main.annual_price' => 'Annual Price',
    'admin_plans.main.lifetime_price' => 'Lifetime deal price',
    'admin_plans.main.price_help' => 'Set 0 to disable the %s',
    'admin_plans.main.color' => 'Color',
    'admin_plans.main.color_help' => 'Set a color to highlight the plan, leave empty for the default color.',
    'admin_plans.main.taxes_ids' => 'Applied Taxes',
    'admin_plans.main.taxes_ids_help' => 'Easily select which of your %screated taxes%s you want to apply per plan.',
    'admin_plans.main.codes_ids' => 'Applied Codes',
    'admin_plans.main.codes_ids_help' => 'Easily select which of your %screated codes%s you want to apply per plan.',
    'admin_plans.main.trial_days' => 'Trial days',
    'admin_plans.main.trial_days_help' => 'Set 0 if you do not want to offer a trial for this plan.',
    'admin_plans.main.custom_help' => '<strong>Updating this plan will not affect any users who are on a custom plan.</strong> Use the user update page instead if you want to edit a particular custom plan of a user. It will only affect the plan displayed on the front-end plans section.',

    'admin_plans.plan.header' => 'Plan settings',
    'admin_plans.plan.unlimited' => 'Set -1 for unlimited.',
    'admin_plans.plan.per_month' => 'per month',
    'admin_plans.plan.url_minimum_characters' => 'Minimum link URL characters',
    'admin_plans.plan.url_maximum_characters' => 'Maximum link URL characters',
    'admin_plans.plan.stores_limit' => 'Stores limit',
    'admin_plans.plan.menus_limit' => 'Menus limit',
    'admin_plans.plan.categories_limit' => 'Categories limit',
    'admin_plans.plan.items_limit' => 'Items limit',
    'admin_plans.plan.domains_limit' => 'Custom domains limit',
    'admin_plans.plan.statistics_retention' => 'Store statistics retention',
    'admin_plans.plan.statistics_retention_help' => 'How many days will the stores statistics be kept in the database.',
    'admin_plans.plan.no_ads' => 'No Ads',
    'admin_plans.plan.no_ads_help' => 'Enabling this will make all people having this plan to not see any ads.',
    'admin_plans.plan.ordering_is_enabled' => 'Ordering System',
    'admin_plans.plan.ordering_is_enabled_help' => 'Enable access to the ordering system of the stores.',
    'admin_plans.plan.additional_domains' => 'Additional domains',
    'admin_plans.plan.additional_domains_help' => 'Enable access to the additional custom domains that the admin has added via the admin panel.',
    'admin_plans.plan.password_protection_is_enabled' => 'Password protection',
    'admin_plans.plan.password_protection_is_enabled_help' => 'Enable access to password protect stores.',
    'admin_plans.plan.analytics_is_enabled' => 'Analytics',
    'admin_plans.plan.analytics_is_enabled_help' => 'Enable analytics for stores.',
    'admin_plans.plan.qr_is_enabled' => 'QR code builder',
    'admin_plans.plan.qr_is_enabled_help' => 'Enable QR code builder for stores.',
    'admin_plans.plan.removable_branding_is_enabled' => 'Removable branding',
    'admin_plans.plan.removable_branding_is_enabled_help' => 'Enable ability to remove the branding from the store pages.',
    'admin_plans.plan.custom_url_is_enabled' => 'Custom back-half URL',
    'admin_plans.plan.custom_url_is_enabled_help' => 'Enable ability to choose a custom URL when creating a store.',
    'admin_plans.plan.search_engine_block_is_enabled' => 'Block Search Engine indexing',
    'admin_plans.plan.search_engine_block_is_enabled_help' => 'Enable ability to block search engines from indexing stores.',
    'admin_plans.plan.custom_css_is_enabled' => 'Custom CSS',
    'admin_plans.plan.custom_css_is_enabled_help' => 'Enable ability to add custom css for each store. Be aware to only allow trusted people to use this feature.',
    'admin_plans.plan.custom_js_is_enabled' => 'Custom JS',
    'admin_plans.plan.custom_js_is_enabled_help' => 'Enable ability to add custom js for each store. Be aware to only allow trusted people to use this feature.',
    'admin_plans.plan.email_reports_is_enabled' => 'Email Reports',
    'admin_plans.plan.email_reports_is_enabled_help' => 'Enable ability for the user to get analytics email reports for each store.',
    'admin_plans.plan.online_payments_is_enabled' => 'Online payments',
    'admin_plans.plan.online_payments_is_enabled_help' => 'Enable ability for the user to accept online payments (paypal, stripe) for each store of their stores.',
    'admin_plans.plan.api_is_enabled' => 'API access',
    'admin_plans.plan.api_is_enabled_help' => 'Enable ability for the user to use the REST API.',
    'admin_plans.plan.affiliate_commission_percentage' => 'Affiliate earning percentage',
    'admin_plans.plan.affiliate_commission_percentage_help' => 'Set to 0 to not allow the user to use this feature.',
    'admin_plans.plan.teams_limit' => 'Teams limit',
    'admin_plans.plan.team_members_limit' => 'Team members limit',


    'admin_plan_delete_modal.header' => 'Delete plan',
    'admin_plan_delete_modal.subheader' => 'By deleting the plan, all the recurring subscriptions of this plan will be cancelled. Users will still have their features they paid for until the Expiration Date of the plan. This action cannot be undone.',


    'admin_plan_create.breadcrumb' => 'Create plan',
    'admin_plan_create.title' => 'Create plan',
    'admin_plan_create.menu' => 'Create plan',
    'admin_plan_create.header' => 'Create a new plan',



    'admin_plan_update.breadcrumb' => 'Edit plan',
    'admin_plan_update.title' => 'Edit plan',
    'admin_plan_update.header' => 'Edit plan',
    'admin_plan_update.update_users_plan_settings.button' => 'Update and update plan subscribers as well',
    'admin_plan_update.update_users_plan_settings.button_help' => 'By updating the plan subscribers you will overwrite all their current settings with the new settings of this plan.',
    'admin_plan_update.error_message.disabled_plans' => 'You are not allowed to disable all the plans which are available (Custom plans are not considered if the payment system is disabled).',

    'admin_codes.breadcrumb' => 'Codes',
    'admin_codes.title' => 'Codes',
    'admin_codes.menu' => 'Codes',
    'admin_codes.header' => 'Codes',
    'admin_codes.header_no_data' => 'Create your first code',
    'admin_codes.subheader_no_data' => 'Create discount codes or fully redeemable codes that you can share to your users.',
    'admin_codes.create' => 'Create code',

    'admin_codes.main.type_discount' => 'Discount',
    'admin_codes.main.type_redeemable' => 'Redeemable',
    'admin_codes.main.days' => 'Days',
    'admin_codes.main.days_help' => 'How many days will the plan be available for.',
    'admin_codes.main.code' => 'Code',
    'admin_codes.main.discount' => 'Discount',
    'admin_codes.main.discount_help' => 'Choose a discount between 1% and 99% off for the code',
    'admin_codes.main.quantity' => 'Quantity',
    'admin_codes.main.quantity_help' => 'How many time the code can be used.',
    'admin_codes.main.is_bulk' => 'Bulk generator',
    'admin_codes.main.amount' => 'Amount of unique codes',
    'admin_codes.main.prefix' => 'Prefix for the generated unique codes',
    'admin_codes.main.redeemed' => 'Redeemed',


    'admin_code_create.breadcrumb' => 'Create code',
    'admin_code_create.title' => 'Create code',
    'admin_code_create.menu' => 'Create code',
    'admin_code_create.header' => 'Create a new code',


    'admin_code_update.breadcrumb' => 'Edit code',
    'admin_code_update.title' => 'Edit code',
    'admin_code_update.header' => 'Edit code',
    'admin_code_update.subheader' => 'Changing the settings will not have any effect on already redeemed or used codes.',
    'admin_code_update.subheader2' => 'You can share the code with a shareable link: %s',

    'admin_taxes.breadcrumb' => 'Taxes',
    'admin_taxes.title' => 'Taxes',
    'admin_taxes.menu' => 'Taxes',
    'admin_taxes.header' => 'Taxes',
    'admin_taxes.header_no_data' => 'Create your first tax',
    'admin_taxes.subheader_no_data' => 'Create taxes that you can use and apply to paid plans.',
    'admin_taxes.create' => 'Create tax',

    'admin_taxes.table.tax' => 'Tax',
    'admin_taxes.table.billing_type' => 'Billing for',

    'admin_taxes.main.value' => 'Tax value',
    'admin_taxes.main.value_type' => 'Value Type',
    'admin_taxes.main.value_type_percentage' => 'Percentage',
    'admin_taxes.main.value_type_fixed' => 'Fixed',
    'admin_taxes.main.type_inclusive' => 'Inclusive',
    'admin_taxes.main.type_exclusive' => 'Exclusive',
    'admin_taxes.main.billing_type' => 'Billing for',
    'admin_taxes.main.billing_type_personal' => 'Personal only',
    'admin_taxes.main.billing_type_business' => 'Business only',
    'admin_taxes.main.billing_type_both' => 'Personal & Business',
    'admin_taxes.main.billing_type_help' => 'Select for who you want to apply this tax for.',
    'admin_taxes.main.countries_help' => 'Select the countries that you want to apply this tax on. Leave empty if you want the tax to be applied for all countries.',

    'admin_tax_create.breadcrumb' => 'Create tax',
    'admin_tax_create.title' => 'Create tax',
    'admin_tax_create.menu' => 'Create tax',
    'admin_tax_create.header' => 'Create a new tax',
    'admin_tax_create.subheader' => 'Once a tax is created, it can\'t be edited or deleted. After the tax is created, you can associate it with your created Plans.',

    'admin_tax_update.breadcrumb' => 'Edit tax',
    'admin_tax_update.title' => 'Edit tax',
    'admin_tax_update.header' => 'Edit tax',


    'admin_tax_delete_modal.header' => 'Delete tax',
    'admin_tax_delete_modal.subheader' => 'If you delete this tax while it is being used for a previous registered payment, you will lose important invoice data. This action cannot be undone.',


    'admin_affiliates_withdrawals.title' => 'Affiliates withdrawals',
    'admin_affiliates_withdrawals.menu' => 'Aff. withdrawals',
    'admin_affiliates_withdrawals.header' => 'Affiliates withdrawals',

    'admin_affiliates_withdrawals.table.amount' => 'Amount',
    'admin_affiliates_withdrawals.table.is_paid' => 'Is paid',
    'admin_affiliates_withdrawals.table.is_paid_paid' => 'Paid',
    'admin_affiliates_withdrawals.table.is_paid_pending' => 'Pending',
    'admin_affiliates_withdrawals.table.action_pay_affiliate_withdrawal' => 'Approve withdrawal',


    'admin_affiliate_withdrawal_approve_modal.header' => 'Approve withdrawal',
    'admin_affiliate_withdrawal_approve_modal.subheader' => 'If you approve the withdrawal, the affiliate withdrawal will be considered as completed and the user will get notified via email. Don\'t forget to send their payment.',
    'admin_affiliate_withdrawal_approve_modal.success_message' => 'Affiliate withdrawal request was approved.',


    'admin_payments.title' => 'Payments list',
    'admin_payments.header' => 'Payments list',
    'admin_payments.menu' => 'Payments',

    'admin_payments.table.plan' => 'Plan',
    'admin_payments.table.total_amount' => 'Total Amount',
    'admin_payments.table.action_view_proof' => 'View proof',
    'admin_payments.table.action_approve_proof' => 'Approve payment',
    'admin_payments.table.invoice' => 'Invoice',

    'admin_payments.filters.status_paid' => 'Paid',
    'admin_payments.filters.status_pending' => 'Pending',
    'admin_payments.filters.plan_id' => 'Plan',
    'admin_payments.filters.search_by_payment_id' => 'External Payment ID',
    'admin_payments.filters.order_by_total_amount' => 'Total amount',


    'admin_payment_approve_modal.header' => 'Approve payment',
    'admin_payment_approve_modal.subheader' => 'If you approve the payment, the plan for the user will start.',
    'admin_payment_approve_modal.success_message' => 'Payment approval was performed successfully.',


    'admin_index.title' => 'Admin Dashboard',
    'admin_index.menu' => 'Dashboard',
    'admin_index.header' => 'Welcome back, %s 👋',
    'admin_index.support.inactive' => 'You are not eligible for receiving support anymore. %sExtend your support%s now.',
    'admin_index.users' => 'Latest users',
    'admin_index.active_users' => '%s online users',
    'admin_index.active_users_tooltip' => 'In the last 15 minutes.',
    'admin_index.payments' => 'Latest payments',
    'admin_index.payments_total_amount' => 'Earned',
    'admin_index.admins_notifications' => 'Admin notifications',
    'admin_index.orders' => 'Orders',
    'admin_index.menus' => 'Menus',
    'admin_index.items' => 'Items',

    'admin_index.display.stores' => 'Stores',
    'admin_index.display.domains' => 'Domains',
    'admin_index.display.users' => 'Users',
    'admin_index.display.payments' => 'Payments',

    'admin_users.breadcrumb' => 'Users',
    'admin_users.title' => 'Users',
    'admin_users.header' => 'Users',
    'admin_users.menu' => 'Users',

    'admin_users.table.datetime' => 'Registration date: %s',
    'admin_users.table.last_activity' => 'Last activity: %s',
    'admin_users.table.total_logins' => 'Total logins: %s',

    'admin_users.main.user_id' => 'User ID',
    'admin_users.main.plan_id' => 'Plan',
    'admin_users.main.plan_expiration_date' => 'Plan expiration date',
    'admin_users.main.type' => 'Privileges',
    'admin_users.main.type_help' => 'Admin users will have the same privileges as you, be careful!',
    'admin_users.main.type_admin' => 'Admin',
    'admin_users.main.type_user' => 'User',
    'admin_users.main.source' => 'Source',
    'admin_users.main.source.direct' => 'Direct sign up',
    'admin_users.main.source.admin_create' => 'Admin created',
    'admin_users.main.source.admin_api_create' => 'Admin API created',
    'admin_users.main.source.facebook' => 'Facebook login',
    'admin_users.main.source.google' => 'Google login',
    'admin_users.main.source.discord' => 'Discord login',
    'admin_users.main.source.twitter' => 'X login',
    'admin_users.main.source.linkedin' => 'LinkedIn login',
    'admin_users.main.source.microsoft' => 'Microsoft login',
    'admin_users.main.status_active' => 'Active',
    'admin_users.main.status_disabled' => 'Disabled',
    'admin_users.main.status_unconfirmed' => 'Unconfirmed',
    'admin_users.main.datetime' => 'Registration date',
    'admin_users.main.total_logins' => 'Total logins',
    'admin_users.main.api_key' => 'API Key',
    'admin_users.main.last_activity' => 'Last active',
    'admin_users.main.plan_trial_done' => 'Trial is done',
    'admin_users.main.plan_expiry_reminder' => 'Plan expiry reminder sent',
    'admin_users.main.payment_subscription_id' => 'Last subscription id',
    'admin_users.main.payment_processor' => 'Last payment processor',
    'admin_users.main.payment_total_amount' => 'Last payment amount',
    'admin_users.main.referral_key' => 'Referral key',
    'admin_users.main.referred_by' => 'Referred by',
    'admin_users.main.referred_by_has_converted' => 'Converted referral',
    'admin_users.main.timezone' => 'Timezone',
    'admin_users.main.twofa_is_enabled' => 'Two-factor authentication',
    'admin_users.main.anti_phishing_code' => 'Anti phishing code',
    'admin_users.main.user_deletion_reminder' => 'User deletion reminder sent',
    'admin_users.main.is_newsletter_subscribed' => 'Is newsletter subscribed',

    'admin_users.error_message.self_delete' => 'You can\'t delete yourself.',
    'admin_users.error_message.name_length' => 'The name field must be between 1 and 64 characters.',
    'admin_users.error_message.email_exists' => 'This email is already used by another account.',


    'admin_user_login_modal.header' => 'Login as this user',
    'admin_user_login_modal.subheader' => 'By logging in as another user, you will be logged out of the current account and fully logged in to this user.',
    'admin_user_login_modal.success_message' => 'Successfully logged in as %s! To get out of this account simply use the logout function.',


    'admin_user_create.breadcrumb' => 'Create user',
    'admin_user_create.title' => 'Create user',
    'admin_user_create.header' => 'Create user',
    'admin_user_create.menu' => 'Create user',


    'admin_user_update.breadcrumb' => 'Edit user',
    'admin_user_update.title' => 'Edit user',
    'admin_user_update.header' => 'Edit user',


    'admin_user_update.plan.header' => 'Plan',
    'admin_user_update.plan.plan_expiration_date_invalid' => 'You must set the plan expiration date some time in the future.',

    'admin_user_update.change_password.header' => 'Change password',
    'admin_user_update.change_password.subheader' => 'Leave it empty if you don\'t want to change the password.',
    'admin_user_update.change_password.new_password' => 'New password',
    'admin_user_update.change_password.repeat_password' => 'Repeat password',


    'admin_user_view.breadcrumb' => 'View user',
    'admin_user_view.title' => 'View user',
    'admin_user_view.header' => 'View user',
    'admin_user_view.billing' => 'Billing details',
    'admin_user_view.referred_by' => 'Referrals',
    'admin_user_view.stores' => 'Stores',
    'admin_user_view.orders' => 'Orders',
    'admin_user_view.menus' => 'Menus',
    'admin_user_view.categories' => 'Categories',
    'admin_user_view.items' => 'Items',


    'admin_users_logs.title' => 'Users logs',
    'admin_users_logs.header' => 'Users logs',
    'admin_users_logs.menu' => 'Users logs',


    'admin_internal_notifications.breadcrumb' => 'Users notifications',
    'admin_internal_notifications.title' => 'Users notifications',
    'admin_internal_notifications.header' => 'Users notifications',
    'admin_internal_notifications.header_no_data' => 'Create your broadcast of notifications',
    'admin_internal_notifications.subheader_no_data' => 'Send informational messages, offers and any type of message to your users.',
    'admin_internal_notifications.menu' => 'Users notifications',
    'admin_internal_notifications.create' => 'Create notification',
    'admin_internal_notifications.table.internal_notification' => 'Notification',
    'admin_internal_notifications.main.title' => 'Title',
    'admin_internal_notifications.main.from_who' => 'From',
    'admin_internal_notifications.main.from_who.system' => 'System',
    'admin_internal_notifications.main.from_who.admin' => 'Admin',
    'admin_internal_notifications.main.for_who' => 'For',
    'admin_internal_notifications.main.for_who.user' => 'User',
    'admin_internal_notifications.main.for_who.admin' => 'Admin',
    'admin_internal_notifications.main.is_read' => 'Is read',
    'admin_internal_notifications.main.read_datetime' => 'Read on %s',
    'admin_internal_notifications.main.filters.read_datetime' => 'Read datetime',
    'admin_internal_notifications.main.segment' => 'Segment',
    'admin_internal_notifications.main.segment.all' => 'All users',
    'admin_internal_notifications.main.segment.custom' => 'Custom',
    'admin_internal_notifications.main.segment.filter' => 'Filter',
    'admin_internal_notifications.main.segment.filter.is_newsletter_subscribed' => 'Is subscribed?',
    'admin_internal_notifications.main.segment.filter.plans' => 'Plans',
    'admin_internal_notifications.main.users_ids' => 'Users IDs',
    'admin_internal_notifications.main.users_ids_placeholder' => '1,2,3',
    'admin_internal_notifications.main.users_ids_help' => 'Comma separated values.',
    'admin_internal_notifications.main.variables' => 'You can use the following dynamic variables: <code>{{WEBSITE_TITLE}}</code>, <code>{{NAME}}</code>, <code>{{EMAIL}}</code>.',


    'admin_internal_notification_create.breadcrumb' => 'Create notification',
    'admin_internal_notification_create.title' => 'Create notification',
    'admin_internal_notification_create.menu' => 'Create notification',
    'admin_internal_notification_create.header' => 'Create a new notification',
    'admin_internal_notification_create.send' => 'Send notification',


    'admin_push_notifications.breadcrumb' => 'Push notifications',
    'admin_push_notifications.title' => 'Push notifications',
    'admin_push_notifications.header' => 'Push notifications',
    'admin_push_notifications.header_no_data' => 'Create your broadcast of notifications',
    'admin_push_notifications.subheader_no_data' => 'Send informational messages, offers and any type of message to your users.',
    'admin_push_notifications.menu' => 'Push notifications',
    'admin_push_notifications.create' => 'Create notification',
    'admin_push_notifications.table.push_notification' => 'Notification',
    'admin_push_notifications.main.title' => 'Title',
    'admin_push_notifications.main.total_push_notifications' => 'Total push notifications',
    'admin_push_notifications.main.sent_push_notifications' => 'Sent push notifications',
    'admin_push_notifications.main.push_subscribers_ids' => 'Push Subscribers IDs',
    'admin_push_notifications.main.push_subscribers_ids_placeholder' => '1,2,3',
    'admin_push_notifications.main.push_subscribers_ids_help' => 'Comma separated values.',
    'admin_push_notifications.main.segment' => 'Segment',
    'admin_push_notifications.main.segment.all' => 'All subscribers',
    'admin_push_notifications.main.segment.custom' => 'Custom',
    'admin_push_notifications.main.segment.filter' => 'Filter',
    'admin_push_notifications.main.segment.filter.is_registered' => 'Is registered?',
    'admin_push_notifications.main.status.draft' => 'Draft',
    'admin_push_notifications.main.status.processing' => 'Processing',
    'admin_push_notifications.main.status.sent' => 'Sent',
    'admin_push_notifications.main.last_sent_datetime' => 'Last sent notification %s',

    'admin_push_notification_create.breadcrumb' => 'Create notification',
    'admin_push_notification_create.title' => 'Create notification',
    'admin_push_notification_create.menu' => 'Create notification',
    'admin_push_notification_create.header' => 'Create a new notification',
    'admin_push_notification_create.save' => 'Save draft',
    'admin_push_notification_create.send' => 'Send notification',
    'admin_push_notification_create.success_message.save' => '%s notification was saved. You can come back later and send it.',
    'admin_push_notification_create.success_message.send' => '%s notification will start to be processed.',


    'admin_push_notification_update.breadcrumb' => 'Update notification',
    'admin_push_notification_update.title' => 'Update notification',
    'admin_push_notification_update.menu' => 'Update notification',
    'admin_push_notification_update.header' => 'Update notification',
    'admin_push_notification_update.error_message.processing' => 'You can not view or update a push notification while it is processing.',


    'admin_push_subscribers.breadcrumb' => 'Push subscribers',
    'admin_push_subscribers.title' => 'Push subscribers',
    'admin_push_subscribers.header' => 'Push subscribers',
    'admin_push_subscribers.header_no_data' => 'No push subscribers',
    'admin_push_subscribers.subheader_no_data' => 'There are no push subscribers right now, here you will see a list with all of them when you get some.',
    'admin_push_subscribers.menu' => 'Push subscribers',
    'admin_push_subscribers.table.push_subscriber' => 'Push subscriber',


    'admin_redeemed_codes.title' => 'Redeemed codes',
    'admin_redeemed_codes.header' => 'Redeemed codes',
    'admin_redeemed_codes.menu' => 'Redeemed codes',
    'admin_redeemed_codes.table.code' => 'Code',


    'admin_settings.title' => 'Settings',
    'admin_settings.menu' => 'Settings',
    'admin_settings.header' => 'Settings',
    'admin_settings.documentation' => 'Read the <a href="https://altumco.de/66qrmenu-docs" target="_blank">Documentation</a> to get more details on certain available configurations.',
    'admin_settings.payment_processors' => 'Payment processors',
    'admin_settings.social_logins' => 'Social logins',
    'admin_settings.social_logins.callback_url' => 'Callback URL',

    'admin_settings.main.tab' => 'Main',
    'admin_settings.main.title' => 'Website title',
    'admin_settings.main.default_language' => 'Default language',
    'admin_settings.main.default_theme_style' => 'Default theme style',
    'admin_settings.main.theme_style_change_is_enabled' => 'Enable theme style selector',
    'admin_settings.main.theme_style_change_is_enabled_help' => 'Display the user a theme style selector button in the footer frontend.',
    'admin_settings.main.logo_light' => 'Logo for light theme',
    'admin_settings.main.logo_dark' => 'Logo for dark theme',
    'admin_settings.main.logo_email' => 'Logo for sent emails',
    'admin_settings.main.favicon' => 'Favicon',
    'admin_settings.main.opengraph' => 'Opengraph image',
    'admin_settings.main.se_indexing' => 'Allow search engines indexing',
    'admin_settings.main.display_index_plans' => 'Display plans on the index page',
    'admin_settings.main.display_index_testimonials' => 'Display testimonials on the index page',
    'admin_settings.main.display_index_faq' => 'Display FAQ on the index page',
    'admin_settings.main.default_timezone' => 'Default timezone',
    'admin_settings.main.default_timezone_help' => 'The default timezone for users when they are registering (they can change it later on).',
    'admin_settings.main.index_url' => 'Custom landing page URL',
    'admin_settings.main.index_url_help' => 'Disable the original landing page & redirect to a new one. Leave empty to disable.',
    'admin_settings.main.not_found_url' => 'Custom 404 page URL',
    'admin_settings.main.not_found_url_help' => 'Disable the original 404 not found page & redirect to a new one. Leave empty to disable.',
    'admin_settings.main.terms_and_conditions_url' => 'Terms and Conditions URL',
    'admin_settings.main.terms_and_conditions_url_help' => 'Link to the terms and conditions of the website. It will be displayed to the user when signing up & when making a payment.',
    'admin_settings.main.privacy_policy_url' => 'Privacy Policy URL',
    'admin_settings.main.privacy_policy_url_help' => 'Link to the privacy policy of the website. It will be displayed to the user when signing up & when making a payment.',
    'admin_settings.main.default_results_per_page' => 'Default results per page',
    'admin_settings.main.default_order_type' => 'Default results order',
    'admin_settings.main.auto_language_detection_is_enabled' => 'Auto Language Detection',
    'admin_settings.main.auto_language_detection_is_enabled_help' => 'Your visitors will be automatically redirected to their browser\'s language, if that particular language is available on your site.',
    'admin_settings.main.api_is_enabled' => 'Enable users API system',
    'admin_settings.main.openai_api_key' => 'OpenAI API Key',
    'admin_settings.main.openai_api_key_help' => 'This field is only used for the automatic translation of the language packs in the admin panel.',
    'admin_settings.main.openai_model' => 'OpenAI Model',
    'admin_settings.main.sitemap_url' => 'Sitemap URL',
    'admin_settings.main.force_https_is_enabled' => 'Force HTTPS',
    'admin_settings.main.force_https_is_enabled_help' => 'Your config.php SITE_URL is: <code>%s</code>. Only enable this feature after you made sure the SITE_URL value of your config.php file starts with <code>https://</code>.',
    'admin_settings.main.broadcasts_statistics_is_enabled' => 'Track email views & clicks for Broadcasts',
    'admin_settings.main.broadcasts_statistics_is_enabled_help' => 'Enabling this feature will increase the load on your server and database storage.',

    'admin_settings.users.tab' => 'Users',
    'admin_settings.users.welcome_email_is_enabled' => 'Welcome email',
    'admin_settings.users.welcome_email_is_enabled_help' => 'Send out a welcome email when a user finishes registration.',
    'admin_settings.users.email_confirmation' => 'Email confirmation',
    'admin_settings.users.email_confirmation_help' => 'Send out email confirmation when a user registers or changes his email address.',
    'admin_settings.users.register_is_enabled' => 'Enable new users registration',
    'admin_settings.users.register_is_enabled_help' => 'Allow people to register on your platform or completely disable the register page.',
    'admin_settings.users.register_only_social_logins' => 'Social logins registration only',
    'admin_settings.users.register_only_social_logins_help' => 'Enable this if you only want to allow your users to register/login with the social logins.',
    'admin_settings.users.register_social_login_require_password' => 'Social logins registration require password',
    'admin_settings.users.register_social_login_require_password_help' => 'Enable this if you want your users to be required to set an account password when first registering via a social login.',
    'admin_settings.users.register_display_newsletter_checkbox' => 'Display newsletter sign up checkbox on registration page',
    'admin_settings.users.auto_delete_unconfirmed_users' => 'Auto delete unconfirmed users',
    'admin_settings.users.auto_delete_unconfirmed_users_help' => 'The amount of days it take for a user to be deleted if unconfirmed, no reminders will be sent as they are unconfirmed users. Set 0 to disable this feature.',
    'admin_settings.users.auto_delete_inactive_users' => 'Auto delete inactive users',
    'admin_settings.users.auto_delete_inactive_users_help' => 'The amount of days it take for a user to be deleted if inactive (only valid for Free users). Set 0 to disable this feature.',
    'admin_settings.users.user_deletion_reminder' => 'User deletion reminder',
    'admin_settings.users.user_deletion_reminder_help' => 'How many days prior should the user get reminded that his account is going to be deleted for inactivity. Set 0 to disable the reminder.',
    'admin_settings.users.blacklisted_domains' => 'Blacklisted domains',
    'admin_settings.users.blacklisted_domains_help' => 'Comma separated values of domains ( word1, word2, word3 ..etc ). People will not be able to register with any domains included in this list.',
    'admin_settings.users.blacklisted_countries' => 'Select blacklisted countries',
    'admin_settings.users.blacklisted_countries_help' => 'Select the countries that you want to blacklist from registering to the system. Detection is IP based.',
    'admin_settings.users.lockouts' => 'Anti spam measures',
    'admin_settings.users.login_lockout_is_enabled' => 'Login lockout is enabled',
    'admin_settings.users.login_lockout_max_retries' => 'Max login retries',
    'admin_settings.users.login_lockout_time' => 'Lockout time',
    'admin_settings.users.lost_password_lockout_is_enabled' => 'Password reset lockout is enabled',
    'admin_settings.users.lost_password_lockout_max_retries' => 'Max reset retries',
    'admin_settings.users.lost_password_lockout_time' => 'Lockout time',
    'admin_settings.users.resend_activation_lockout_is_enabled' => 'Resend activation lockout is enabled',
    'admin_settings.users.resend_activation_lockout_max_retries' => 'Max resend retries',
    'admin_settings.users.resend_activation_lockout_time' => 'Lockout time',
    'admin_settings.users.register_lockout_is_enabled' => 'Register lockout is enabled',
    'admin_settings.users.register_lockout_max_registrations' => 'Max registrations',
    'admin_settings.users.register_lockout_time' => 'Lockout time',

    'admin_settings.content.tab' => 'Content',
    'admin_settings.content.blog' => 'Blog',
    'admin_settings.content.blog_is_enabled' => 'Enable blog system',
    'admin_settings.content.blog_share_is_enabled' => 'Enable blog share post buttons',
    'admin_settings.content.blog_search_widget_is_enabled' => 'Enable blog search widget',
    'admin_settings.content.blog_categories_widget_is_enabled' => 'Enable blog categories widget',
    'admin_settings.content.blog_popular_widget_is_enabled' => 'Enable blog popular posts widget',
    'admin_settings.content.blog_views_is_enabled' => 'Enable blog views count to be displayed',
    'admin_settings.content.pages' => 'Resources',
    'admin_settings.content.pages_is_enabled' => 'Enable resources (pages) system',
    'admin_settings.content.pages_share_is_enabled' => 'Enable pages share post buttons',
    'admin_settings.content.pages_popular_widget_is_enabled' => 'Enable pages popular posts widget',
    'admin_settings.content.pages_views_is_enabled' => 'Enable pages views count to be displayed',

    'admin_settings.payment.tab' => 'Payment',
    'admin_settings.payment.is_enabled' => 'Enable Payments System',
    'admin_settings.payment.is_enabled_help' => 'Disabling the payment system will remove all the options for the users to upgrade their accounts or see any payment related information.',
    'admin_settings.payment.default_payment_frequency' => 'Default payment frequency',
    'admin_settings.payment.type' => 'Enabled payment types',
    'admin_settings.payment.type_one_time' => 'One Time',
    'admin_settings.payment.type_recurring' => 'Recurring',
    'admin_settings.payment.type_both' => 'Both',
    'admin_settings.payment.brand_name' => 'Brand Name',
    'admin_settings.payment.brand_name_help' => 'The brand name will be used for displaying the brand when users purchase via payment gates. (ex: paypal)',
    'admin_settings.payment.currencies' => 'Currencies',
    'admin_settings.payment.currencies.code' => 'Currency code',
    'admin_settings.payment.currencies.code_help' => 'Currency code for the payments (ex: USD, EUR, CAD).',
    'admin_settings.payment.currencies.symbol' => 'Currency symbol',
    'admin_settings.payment.currencies.default_payment_processor' => 'Default processor',
    'admin_settings.payment.currencies.default_payment_processor_help' => 'Make sure the payment processor has this particular currency code enabled.',
    'admin_settings.payment.default_currency' => 'Default currency',
    'admin_settings.payment.default_currency_help' => 'Default currency code for the payments. Once you start receiving payments, do not change this value.',
    'admin_settings.payment.codes_is_enabled' => 'Enable Discount/Redeemable Codes',
    'admin_settings.payment.codes_is_enabled_help' => 'Enabling the discount codes system will enable users to add a discount code created from the admin panel, before they checkout.',
    'admin_settings.payment.taxes_and_billing_is_enabled' => 'Enable Taxes & Billing system',
    'admin_settings.payment.taxes_and_billing_is_enabled_help' => 'Enabling this feature will require users to fill in their Billing info before checking out and you will also be able to create taxes for each created plan.',
    'admin_settings.payment.invoice_is_enabled' => 'Enable Invoices System',
    'admin_settings.payment.invoice_is_enabled_help' => 'This option will determine if users will be able to see invoices for their payments or not.',
    'admin_settings.payment.webhook_url' => 'Webhook URL',
    'admin_settings.payment.mode' => 'Mode',
    'admin_settings.payment.user_plan_expiry_reminder' => 'User plan expiry reminder',
    'admin_settings.payment.user_plan_expiry_reminder_help' => 'How many days prior should the user get reminded that his plan is going to expire. Set 0 to disable the reminder.',
    'admin_settings.payment.currency_exchange_api_key' => 'Currency exchange API key',
    'admin_settings.payment.currency_exchange_api_key_help' => 'This API key is needed only in case you use multiple currencies across your website.',

    'admin_settings.paypal.tab' => 'Paypal',
    'admin_settings.paypal.is_enabled' => 'Enable Paypal payments',
    'admin_settings.paypal.client_id' => 'Client Id',
    'admin_settings.paypal.secret' => 'Secret',

    'admin_settings.stripe.tab' => 'Stripe',
    'admin_settings.stripe.is_enabled' => 'Enable Stripe payments',
    'admin_settings.stripe.publishable_key' => 'Publishable Key',
    'admin_settings.stripe.secret_key' => 'Secret Key',
    'admin_settings.stripe.webhook_secret' => 'Webhook Secret',

    'admin_settings.offline_payment.tab' => 'Offline payment',
    'admin_settings.offline_payment.is_enabled' => 'Enable offline payments',
    'admin_settings.offline_payment.instructions' => 'Instructions',
    'admin_settings.offline_payment.instructions_help' => 'Payment instructions for the user to see, before submitting the payment.',
    'admin_settings.offline_payment.proof_size_limit' => 'Uploaded proof size limit',

    'admin_settings.coinbase.tab' => 'Coinbase',
    'admin_settings.coinbase.is_enabled' => 'Enable Coinbase payments',
    'admin_settings.coinbase.api_key' => 'API Key',
    'admin_settings.coinbase.webhook_secret' => 'Webhook Secret',

    'admin_settings.payu.tab' => 'PayU',
    'admin_settings.payu.is_enabled' => 'Enable PayU payments',
    'admin_settings.payu.merchant_pos_id' => 'Merchant POS Id',
    'admin_settings.payu.signature_key' => 'Signature Key',
    'admin_settings.payu.oauth_client_id' => 'Oauth Client Id',
    'admin_settings.payu.oauth_client_secret' => 'Oauth Client Secret',

    'admin_settings.iyzico.tab' => 'Iyzico',
    'admin_settings.iyzico.is_enabled' => 'Enable PayU payments',
    'admin_settings.iyzico.api_key' => 'API Key',
    'admin_settings.iyzico.secret_key' => 'Secret Key',

    'admin_settings.paystack.tab' => 'Paystack',
    'admin_settings.paystack.is_enabled' => 'Enable Paystack payments',
    'admin_settings.paystack.public_key' => 'Public Key',
    'admin_settings.paystack.secret_key' => 'Secret Key',

    'admin_settings.razorpay.tab' => 'Razorpay',
    'admin_settings.razorpay.is_enabled' => 'Enable Razorpay payments',
    'admin_settings.razorpay.key_id' => 'Key Id',
    'admin_settings.razorpay.key_secret' => 'Key Secret',
    'admin_settings.razorpay.webhook_secret' => 'Webhook Secret',

    'admin_settings.mollie.tab' => 'Mollie',
    'admin_settings.mollie.is_enabled' => 'Enable Mollie payments',
    'admin_settings.mollie.api_key' => 'API Key',

    'admin_settings.yookassa.tab' => 'Yookassa',
    'admin_settings.yookassa.is_enabled' => 'Enable Yookassa payments',
    'admin_settings.yookassa.shop_id' => 'Shop ID',
    'admin_settings.yookassa.secret_key' => 'Secret Key',

    'admin_settings.crypto_com.tab' => 'Crypto.com',
    'admin_settings.crypto_com.is_enabled' => 'Enable Crypto.com payments',
    'admin_settings.crypto_com.publishable_key' => 'Publishable Key',
    'admin_settings.crypto_com.secret_key' => 'Secret Key',
    'admin_settings.crypto_com.webhook_secret' => 'Webhook Secret',

    'admin_settings.paddle.tab' => 'Paddle',
    'admin_settings.paddle.is_enabled' => 'Enable Paddle payments',
    'admin_settings.paddle.vendor_id' => 'Vendor ID',
    'admin_settings.paddle.api_key' => 'API Key',
    'admin_settings.paddle.public_key' => 'Public Key',

    'admin_settings.mercadopago.tab' => 'MercadoPago',
    'admin_settings.mercadopago.is_enabled' => 'Enable MercadoPago payments',
    'admin_settings.mercadopago.access_token' => 'Access Token',

    'admin_settings.midtrans.tab' => 'Midtrans',
    'admin_settings.midtrans.is_enabled' => 'Enable Midtrans payments',
    'admin_settings.midtrans.server_key' => 'Server Key',

    'admin_settings.flutterwave.tab' => 'Flutterwave',
    'admin_settings.flutterwave.is_enabled' => 'Enable Flutterwave payments',
    'admin_settings.flutterwave.secret_key' => 'Secret Key',

    'admin_settings.affiliate.tab' => 'Affiliate',
    'admin_settings.affiliate.is_enabled' => 'Enable the affiliate system',
    'admin_settings.affiliate.is_enabled_help' => 'The affiliate system will enable your users to get paid for bringing other paying users to your platform.',
    'admin_settings.affiliate.commission_type' => 'Commission type',
    'admin_settings.affiliate.commission_type_once' => 'Once - give out commission for the first payment of a referred user',
    'admin_settings.affiliate.commission_type_forever' => 'Forever - give out commission for all the payments of a referred user',
    'admin_settings.affiliate.tracking_type' => 'Tracking type',
    'admin_settings.affiliate.tracking_type_first' => 'First - track first referrer until the tracking duration expires',
    'admin_settings.affiliate.tracking_type_last' => 'Last - override tracking cookie to the last referred',
    'admin_settings.affiliate.tracking_duration' => 'Tracking duration',
    'admin_settings.affiliate.tracking_duration_help' => 'How long does the affiliate tracking cookie live on the browser.',
    'admin_settings.affiliate.minimum_withdrawal_amount' => 'Minimum withdrawal amount',
    'admin_settings.affiliate.minimum_withdrawal_amount_help' => 'How much does a user need to have in his balance until he can request a withdrawal.',
    'admin_settings.affiliate.withdrawal_notes' => 'Withdrawal request notes',
    'admin_settings.affiliate.withdrawal_notes_help' => 'Inform your users about the withdrawal process. You can request them to write in their bank account or Paypal email for example.',

    'admin_settings.business.tab' => 'Business details',
    'admin_settings.business.subheader' => 'These details will be used for payments & invoices.',
    'admin_settings.business.brand_name' => 'Brand name',
    'admin_settings.business.invoice_nr_prefix' => 'Invoice Nr Prefix',
    'admin_settings.business.invoice_nr_prefix_help' => 'Your Nr Prefix for all the invoices generated on the system. Ex: INV-',
    'admin_settings.business.name' => 'Name',
    'admin_settings.business.address' => 'Address',
    'admin_settings.business.county' => 'County',
    'admin_settings.business.zip' => 'ZIP',
    'admin_settings.business.phone' => 'Phone',
    'admin_settings.business.tax_type' => 'Tax Type',
    'admin_settings.business.tax_type_placeholder' => 'ex: VAT',
    'admin_settings.business.tax_id' => 'Tax ID',
    'admin_settings.business.custom_key_one' => 'Custom Field Name',
    'admin_settings.business.custom_value_one' => 'Custom Field Value',
    'admin_settings.business.custom_key_two' => 'Custom Field Name',
    'admin_settings.business.custom_value_two' => 'Custom Field Value',

    'admin_settings.captcha.tab' => 'Captcha',
    'admin_settings.captcha.type' => 'Captcha provider',
    'admin_settings.captcha.type.basic' => 'Basic captcha (self-hosted)',
    'admin_settings.captcha.type.recaptcha' => 'Google ReCaptcha v2 checkbox',
    'admin_settings.captcha.type.hcaptcha' => 'hCaptcha',
    'admin_settings.captcha.type.turnstile' => 'Cloudflare Turnstile',
    'admin_settings.captcha.recaptcha_public_key' => 'ReCaptcha Public Key',
    'admin_settings.captcha.recaptcha_private_key' => 'ReCaptcha Private Key',
    'admin_settings.captcha.hcaptcha_site_key' => 'hCaptcha Site Key',
    'admin_settings.captcha.hcaptcha_secret_key' => 'hCaptcha Secret Key',
    'admin_settings.captcha.turnstile_site_key' => 'Turnstile Site Key',
    'admin_settings.captcha.turnstile_secret_key' => 'Turnstile Secret Key',
    'admin_settings.captcha.login_is_enabled' => 'Enable captcha on the login page',
    'admin_settings.captcha.register_is_enabled' => 'Enable captcha on the register page',
    'admin_settings.captcha.lost_password_is_enabled' => 'Enable captcha on the lost password page',
    'admin_settings.captcha.resend_activation_is_enabled' => 'Enable captcha on the resend activation page',
    'admin_settings.captcha.contact_is_enabled' => 'Enable captcha on the contact page',

    'admin_settings.facebook.tab' => 'Facebook Login',
    'admin_settings.facebook.is_enabled' => 'Enable Facebook Login',
    'admin_settings.facebook.app_id' => 'App Id',
    'admin_settings.facebook.app_secret' => 'App Secret',

    'admin_settings.google.tab' => 'Google Login',
    'admin_settings.google.is_enabled' => 'Enable Google Login',
    'admin_settings.google.client_id' => 'Client Id',
    'admin_settings.google.client_secret' => 'Client Secret',

    'admin_settings.twitter.tab' => 'X Login',
    'admin_settings.twitter.is_enabled' => 'Enable X Login',
    'admin_settings.twitter.consumer_api_key' => 'Consumer API Key',
    'admin_settings.twitter.consumer_api_secret' => 'Consumer API Secret',

    'admin_settings.discord.tab' => 'Discord Login',
    'admin_settings.discord.is_enabled' => 'Enable Discord Login',
    'admin_settings.discord.client_id' => 'Client ID',
    'admin_settings.discord.client_secret' => 'Client Secret',

    'admin_settings.linkedin.tab' => 'LinkedIn Login',
    'admin_settings.linkedin.is_enabled' => 'Enable LinkedIn Login',
    'admin_settings.linkedin.client_id' => 'Client ID',
    'admin_settings.linkedin.client_secret' => 'Client Secret',

    'admin_settings.microsoft.tab' => 'Microsoft Login',
    'admin_settings.microsoft.is_enabled' => 'Enable Microsoft Login',
    'admin_settings.microsoft.client_id' => 'Client ID',
    'admin_settings.microsoft.client_secret' => 'Client Secret',

    'admin_settings.cookie_consent.tab' => 'Cookie consent',
    'admin_settings.cookie_consent.is_enabled' => 'Enable cookie consent',
    'admin_settings.cookie_consent.is_enabled_help' => 'Cookie consent is made possible with the <a href="https://github.com/orestbida/cookieconsent" target="_blank">orestbida/cookieconsent</a> library. If you add your own custom js and want to make it work with this, <a href="https://github.com/orestbida/cookieconsent#how-to-blockmanage-scripts" target="_blank">read this</a>.',
    'admin_settings.cookie_consent.logging_is_enabled' => 'Enable logging',
    'admin_settings.cookie_consent.logging_is_enabled_help' => 'Enable this will log all the users and their selected cookie consent preferences into a CSV file.',
    'admin_settings.cookie_consent.logging_download' => 'Download consent log',
    'admin_settings.cookie_consent.necessary_is_enabled' => 'Strictly necessary cookies',
    'admin_settings.cookie_consent.analytics_is_enabled' => 'Performance and Analytics cookies',
    'admin_settings.cookie_consent.targeting_is_enabled' => 'Advertisement and Targeting cookies',
    'admin_settings.cookie_consent.layout' => 'Layout type',
    'admin_settings.cookie_consent.position_y' => 'Position Y',
    'admin_settings.cookie_consent.position_x' => 'Position X',

    'admin_settings.socials.tab' => 'Socials',
    'admin_settings.socials.help' => 'Social links to be displayed in the footer of the website.',

    'admin_settings.smtp.tab' => 'SMTP',
    'admin_settings.smtp.host' => 'Host',
    'admin_settings.smtp.host_help' => 'If there are no values entered in this field then the system will try to use the default mail function.',
    'admin_settings.smtp.from' => 'From email',
    'admin_settings.smtp.from_help' => 'The email that the users get the email from / the \'reply-to\' email.',
    'admin_settings.smtp.from_name' => 'From name',
    'admin_settings.smtp.from_name_help' => 'The name associated with the email below.',
    'admin_settings.smtp.encryption' => 'Encryption',
    'admin_settings.smtp.port' => 'Port',
    'admin_settings.smtp.auth' => 'Authentication',
    'admin_settings.smtp.username' => 'Username',
    'admin_settings.smtp.password' => 'Password',

    'admin_settings.theme.tab' => 'Theme',
    'admin_settings.theme.light_ltr' => 'Light - LTR',
    'admin_settings.theme.light_rtl' => 'Light - RTL',
    'admin_settings.theme.dark_ltr' => 'Dark - LTR',
    'admin_settings.theme.dark_rtl' => 'Dark - RTL',
    'admin_settings.theme.primary' => 'Primary color shades - from light to dark',
    'admin_settings.theme.gray' => 'Gray color shades - from light to dark',
    'admin_settings.theme.others' => 'Other settings',
    'admin_settings.theme.border_radius' => 'Border radius',
    'admin_settings.theme.font_family' => 'Font family',
    'admin_settings.theme.font_family_help' => 'Write the CSS font family name. Leave empty for default.',

    'admin_settings.custom.tab' => 'Custom JS / CSS',
    'admin_settings.custom.head_js' => 'App head Javascript',
    'admin_settings.custom.head_js_help' => 'Add your own tracking js code ( ex: Google Analytics ).',
    'admin_settings.custom.head_css' => 'App custom CSS',
    'admin_settings.custom.head_css_help' => 'Add custom CSS in case you want to overwrite certain styles of the website.',
    'admin_settings.custom.head_js_store' => 'Store head Javascript',
    'admin_settings.custom.head_css_store' => 'Store custom CSS',

    'admin_settings.announcements.tab' => 'Announcements',
    'admin_settings.announcements.guests' => 'Guests',
    'admin_settings.announcements.users' => 'Users',
    'admin_settings.announcements.content' => 'Announcement content',
    'admin_settings.announcements.content_help' => 'This field accepts text, html or javascript. Leave empty to disable.',
    'admin_settings.announcements.text_color' => 'Text color',
    'admin_settings.announcements.background_color' => 'Background color',

    'admin_settings.internal_notifications.tab' => 'Internal Notifications',
    'admin_settings.internal_notifications.users_is_enabled' => 'Enable notifications system for users',
    'admin_settings.internal_notifications.admins_is_enabled' => 'Enable notifications system for admins (admin panel)',
    'admin_settings.internal_notifications.new_user' => 'New user',
    'admin_settings.internal_notifications.delete_user' => 'Deleted user',
    'admin_settings.internal_notifications.new_payment' => 'New payment',
    'admin_settings.internal_notifications.new_affiliate_withdrawal' => 'New affiliate withdrawal',
    'admin_settings.internal_notifications.new_newsletter_subscriber' => 'New newsletter subscriber',

    'admin_settings.email_notifications.tab' => 'Email Notifications',
    'admin_settings.email_notifications.emails' => 'Emails to be notified',
    'admin_settings.email_notifications.emails_help' => 'Emails that will receive a notification when one of the actions from below are performed. Add valid email addresses separated by a comma.',
    'admin_settings.email_notifications.new_user' => 'New User',
    'admin_settings.email_notifications.new_user_help' => 'Receive an email when a new users registers to the website.',
    'admin_settings.email_notifications.delete_user' => 'Delete User',
    'admin_settings.email_notifications.delete_user_help' => 'Receive an email when any user deletes their account.',
    'admin_settings.email_notifications.new_payment' => 'New Payment',
    'admin_settings.email_notifications.new_payment_help' => 'Receive an email when a new payment is successfully processed.',
    'admin_settings.email_notifications.new_domain' => 'New Custom Domain',
    'admin_settings.email_notifications.new_domain_help' => 'Receive an email when a new custom domain is pending approval.',
    'admin_settings.email_notifications.contact' => 'Contact page emails',
    'admin_settings.email_notifications.contact_help' => 'Enable the contact system.',
    'admin_settings.email_notifications.new_affiliate_withdrawal' => 'New affiliate withdrawal',
    'admin_settings.email_notifications.new_affiliate_withdrawal_help' => 'Receive an email when a new affiliate withdrawal request is submitted.',

    'admin_settings.push_notifications.tab' => 'Push Notifications',
    'admin_settings.push_notifications.is_enabled' => 'Enable the Push Notifications system',
    'admin_settings.push_notifications.guests_is_enabled' => 'Accept guests as subscribers',
    'admin_settings.push_notifications.guests_is_enabled_help' => 'Accept non registered accounts to subscribe to your push notifications.',
    'admin_settings.push_notifications.ask_to_subscribe_is_enabled' => 'Ask user to subscribe modal',
    'admin_settings.push_notifications.ask_to_subscribe_is_enabled_help' => 'A modal popping up will ask the user to subscribe in case they have not been asked already. Otherwise, they can trigger the modal via the footer link.',
    'admin_settings.push_notifications.ask_to_subscribe_delay' => 'Delay until modal shows up',
    'admin_settings.push_notifications.icon' => 'Icon',

    'admin_settings.offload.tab' => 'Offload & CDN',
    'admin_settings.offload.cdn' => 'CDN',
    'admin_settings.offload.offload' => 'Offload',
    'admin_settings.offload.cdn_assets_url' => 'CDN Assets URL',
    'admin_settings.offload.cdn_uploads_url' => 'CDN Uploads URL',
    'admin_settings.offload.cdn_url_help' => 'The CDN base URL in case you wish to also use a CDN for the offloaded or not offloaded assets. Leave empty to use no CDN.',
    'admin_settings.offload.cdn_origin_url' => 'CDN Origin URL',
    'admin_settings.offload.cdn_origin_url_help' => 'The base URL that you should use in your CDN provider for the CDN to pull data from.',
    'admin_settings.offload.assets_url' => 'Assets URL',
    'admin_settings.offload.assets_url_help' => 'Full URL to the assets folder from any storage provider, such as: Amazon S3, DigitalOcean Spaces. Leave empty to disable assets offloading.',
    'admin_settings.offload.provider' => 'Storage provider',
    'admin_settings.offload.uploads_url' => 'Uploads URL',
    'admin_settings.offload.uploads_url_help' => 'Full URL to the uploads folder from any storage provider, such as: Amazon S3, DigitalOcean Spaces. Leave empty to disable file uploads offloading.',
    'admin_settings.offload.endpoint_url' => 'Endpoint URL',
    'admin_settings.offload.access_key' => 'Access key',
    'admin_settings.offload.secret_access_key' => 'Secret access key',
    'admin_settings.offload.storage_name' => 'Bucket name',
    'admin_settings.offload.region' => 'Region',

    'admin_settings.pwa.tab' => 'PWA',
    'admin_settings.pwa.is_enabled' => 'Enable the PWA system',
    'admin_settings.pwa.app_name' => 'App name',
    'admin_settings.pwa.short_app_name' => 'App short name',
    'admin_settings.pwa.app_description' => 'App short description',
    'admin_settings.pwa.theme_color' => 'Theme color',
    'admin_settings.pwa.app_icon' => 'App icon',
    'admin_settings.pwa.app_icon_help' => 'Make sure the icon is 512x512 pixels.',
    'admin_settings.pwa.app_icon_maskable' => 'App icon maskable',
    'admin_settings.pwa.app_icon_maskable_help' => 'Make sure the icon is 512x512 pixels. <a href="https://web.dev/articles/maskable-icon" target="_blank">What is a maskable icon?</a>',
    'admin_settings.pwa.mobile_screenshots' => 'Mobile screenshots',
    'admin_settings.pwa.mobile_screenshots_help' => 'Those screenshots will be displayed in the installation prompt on mobile phones, these are optional.',
    'admin_settings.pwa.mobile_screenshots_help2' => 'All mobile screenshots must have the same size.',
    'admin_settings.pwa.desktop_screenshots' => 'Desktop screenshots',
    'admin_settings.pwa.desktop_screenshots_help' => 'Those screenshots will be displayed in the installation prompt on desktop phones, these are optional.',
    'admin_settings.pwa.desktop_screenshots_help2' => 'All desktop screenshots must have the same size.',
    'admin_settings.pwa.screenshot_x' => 'Screenshot %s',
    'admin_settings.pwa.shortcuts' => 'Shortcuts',
    'admin_settings.pwa.shortcut_name_x' => 'Shortcut %s - name',
    'admin_settings.pwa.shortcut_description_x' => 'Shortcut %s - description',
    'admin_settings.pwa.shortcut_url_x' => 'Shortcut %s - URL',
    'admin_settings.pwa.shortcut_icon_x' => 'Shortcut %s - Icon',
    'admin_settings.pwa.shortcut_icon_x_help' => 'Make sure the icon is 192x192 pixels.',
    'admin_settings.pwa.app_start_url' => 'App start URL',
    'admin_settings.pwa.app_start_url_help' => 'What internal page should load when the PWA app is opened.',

    'admin_settings.sso.tab' => 'SSO',
    'admin_settings.sso.is_enabled' => 'Enable the SSO (Single Sign On) system',
    'admin_settings.sso.is_enabled_help' => 'This feature allows you to connect other installations of AltumCode software and allow your users to easily switch between them with a single click of a button.',
    'admin_settings.sso.websites' => 'Websites',
    'admin_settings.sso.id' => 'ID',
    'admin_settings.sso.id_help' => 'Simple identification name for the website.',
    'admin_settings.sso.api_key' => 'API Key',
    'admin_settings.sso.api_key_help' => 'The API key of the main admin account of the website.',
    'admin_settings.sso.url_help' => 'The base URL of the another AltumCode software installation.',

    'admin_settings.webhooks.tab' => 'Webhooks',
    'admin_settings.webhooks.help' => 'Send a webhook POST request to the above URL with the %s form data values when this event is triggered.',
    'admin_settings.webhooks.user_new' => 'New users event - webhook URL',
    'admin_settings.webhooks.user_delete' => 'User deletion event - webhook URL',
    'admin_settings.webhooks.payment_new' => 'New payment event - webhook URL',
    'admin_settings.webhooks.code_redeemed' => 'Code redeemed event - webhook URL',
    'admin_settings.webhooks.contact' => 'Contact form - webhook URL',
    'admin_settings.webhooks.domain_new' => 'New user domain event - webhook URL',
    'admin_settings.webhooks.domain_update' => 'Updated user domain event - webhook URL',

    'admin_settings.cron.tab' => 'Cron',
    'admin_settings.cron.cron' => 'Cron job',
    'admin_settings.cron.last_execution' => 'Last executed %s',
    'admin_settings.cron.broadcasts' => 'Broadcasts cron job',
    'admin_settings.cron.push_notifications' => 'Push notifications cron job',

    'admin_settings.health.tab' => 'Health',
    'admin_settings.health.help' => 'This page checks and displays information about your server and tells you if your server minimum requirements are in good order.',

    'admin_settings.cache.tab' => 'Cache',
    'admin_settings.cache.help' => 'This is a page meant for more advanced users, simply ignore it if you don\'t understand what cache is.',
    'admin_settings.cache.size' => 'Current cache size',
    'admin_settings.cache.clear' => 'Clear cache',

    'admin_settings.license.tab' => 'License',
    'admin_settings.license.license' => 'License',
    'admin_settings.license.license_help' => 'The license you got from purchasing the product.',
    'admin_settings.license.type' => 'License type',
    'admin_settings.license.new_license' => 'New license',
    'admin_settings.license.new_license_help' => 'Leave empty if you don\'t want to change it. Useful when changing your license or upgrading to a new one (ex: from Regular License to Extended).',

    'admin_settings.support.tab' => 'Support',
    'admin_settings.support.key' => 'Support key',
    'admin_settings.support.status.active' => 'Active. Will expire on %s.',
    'admin_settings.support.status.active.help' => 'You are eligible for receiving support via support@altumcode.com',
    'admin_settings.support.status.inactive' => 'Inactive. Expired on %s.',
    'admin_settings.support.status.inactive.help' => 'You are not eligible for receiving support anymore.',
    'admin_settings.support.extend' => 'Extend your support',
    'admin_settings.support.new_key' => 'New support key',
    'admin_settings.support.new_key_help' => 'Leave empty if you don\'t want to change it.',

    'admin_settings.ads.tab' => 'Ads',
    'admin_settings.ads.ads_help' => 'Ads will only show users that do not have a plan with the \'No ads\' plan feature enabled. These fields accept text, html or javascript.',
    'admin_settings.ads.ad_blocker_detector_is_enabled' => 'Ad blocker detector',
    'admin_settings.ads.ad_blocker_detector_is_enabled_help' => 'When an ad blocker is detected, the user will see a modal asking him to disable the ad blocker.',
    'admin_settings.ads.ad_blocker_detector_lock_is_enabled' => 'Lock user until ad blocker is disabled',
    'admin_settings.ads.ad_blocker_detector_delay' => 'Delay until lock',
    'admin_settings.ads.header' => 'App header',
    'admin_settings.ads.footer' => 'App footer',
    'admin_settings.ads.header_stores' => 'Stores header',
    'admin_settings.ads.footer_stores' => 'Stores footer',

    'admin_settings.stores.tab' => 'Stores',
    'admin_settings.stores.random_url_length' => 'Random URL length',
    'admin_settings.stores.random_url_length_help' => 'How many characters should be used to generate a random URL slug when a custom one is not given.',
    'admin_settings.stores.branding' => 'Branding',
    'admin_settings.stores.branding_help' => 'This branding is used by default in the stores pages footer. HTML can be used in this field.',
    'admin_settings.stores.domains_is_enabled' => 'Enable the Custom Domains system',
    'admin_settings.stores.domains_is_enabled_help' => 'Enabling this will give your users the ability to add and use custom domains.',
    'admin_settings.stores.additional_domains_is_enabled' => 'Enable the Additional Custom Domains system',
    'admin_settings.stores.additional_domains_is_enabled_help' => 'Enabling this will give you the ability to add global domains via the admin panel that your users can use as additional domains.',
    'admin_settings.stores.main_domain_is_enabled' => 'Enable the usage of the main domain',
    'admin_settings.stores.main_domain_is_enabled_help' => 'Enabling this will give your users the ability to use the main domain to create store pages. This function will only work if the Custom Domains system is enabled and there is at least one global custom domain available. Even if this option is disabled, admins will still be allowed to use the main domain.',
    'admin_settings.stores.domains_custom_main_ip' => 'IP of your server',
    'admin_settings.stores.domains_custom_main_ip_help' => 'The IP that will be displayed when adding a custom domain. Leave empty to show the default detected server IP.',
    'admin_settings.stores.email_reports_is_enabled' => 'Email reports system',
    'admin_settings.stores.email_reports_is_enabled_weekly' => 'Weekly',
    'admin_settings.stores.email_reports_is_enabled_monthly' => 'Monthly',
    'admin_settings.stores.email_reports_is_enabled_help' => 'Enabling the email reports will give your users the ability to get email reports of their stores analytics. Make sure to have a proper email sending configuration via the SMTP tab.',
    'admin_settings.stores.logo_size_limit' => 'Stores logo size limit',
    'admin_settings.stores.image_size_limit' => 'Stores cover image size limit',
    'admin_settings.stores.opengraph_size_limit' => 'Stores opengraph image size limit',
    'admin_settings.stores.favicon_size_limit' => 'Stores favicon size limit',
    'admin_settings.stores.menu_image_size_limit' => 'Stores menu image size limit',
    'admin_settings.stores.item_image_size_limit' => 'Stores item image size limit',

    'admin_settings_send_test_email_modal.header' => 'Send test email',
    'admin_settings_send_test_email_modal.email' => 'Email to send to',
    'admin_settings_send_test_email_modal.success_message' => 'We sent the email commands to your SMTP without receiving any errors.',
    'admin_settings_send_test_email_modal.error_message' => 'We sent the email commands to your SMTP, but we have received the following errors: %s',


    'admin_teams.title' => 'Teams',
    'admin_teams.header' => 'Teams',
    'admin_teams.menu' => 'Teams',


    'admin_plugins.title' => 'Plugins',
    'admin_plugins.menu' => 'Plugins',
    'admin_plugins.header' => 'Plugins',
    'admin_plugins.header_no_data' => 'No plugins available',
    'admin_plugins.subheader_no_data' => 'There are no plugins available for now :(.',
    'admin_plugins.no_access' => 'You must own, install & activate the \'%s\' plugin to use this feature.',
    'admin_plugins.install' => 'Install',
    'admin_plugins.uninstall' => 'Uninstall',
    'admin_plugins.activate' => 'Activate',
    'admin_plugins.disable' => 'Disable',
    'admin_plugins.status_inexistent' => 'Get plugin',
    'admin_plugins.status_uninstalled' => 'Uninstalled',
    'admin_plugins.status_active' => 'Active',
    'admin_plugins.status_disabled' => 'Disabled',
    'admin_plugins.settings' => 'Settings',

    'admin_plugins.table.plugin' => 'Plugin',
    'admin_plugins.table.version' => 'Version',
    'admin_plugins.table.author' => 'Author',
    'admin_plugins.install_message' => '%s has been successfully installed.',
    'admin_plugins.uninstall_message' => '%s has been successfully uninstalled.',
    'admin_plugins.activate_message' => '%s has been successfully activated.',
    'admin_plugins.disable_message' => '%s has been successfully disabled.',

    'admin_plugin_uninstall_modal.header' => 'Uninstall plugin',
    'admin_plugin_uninstall_modal.subheader' => 'By uninstalling the plugin, all the potential data related to the plugin will be removed from the system.',

    'admin_plugin_delete_modal.header' => 'Delete plugin',
    'admin_plugin_delete_modal.subheader' => 'To delete the plugin, simply go into the <strong>plugins</strong> folder and delete the plugin.',


    'admin_languages.breadcrumb' => 'Languages',
    'admin_languages.title' => 'Languages',
    'admin_languages.menu' => 'Languages',
    'admin_languages.header' => 'Languages',
    'admin_languages.header_no_data' => 'No languages available',
    'admin_languages.main_settings' => 'Main settings',
    'admin_languages.translate_app' => 'Translate app',
    'admin_languages.translate_admin' => 'Translate admin',
    'admin_languages.main.auto_translate_all' => 'Auto translate',
    'admin_languages.main.auto_translate_all_help' => 'This button will start translating one by one, each field. You can stop the process at any point by clicking the Escape button.',
    'admin_languages.main.auto_translate' => 'Auto translate',
    'admin_languages.main.auto_translate_help' => 'Make sure to double check the translated results.',
    'admin_languages.main.auto_translate_info' => 'You must add your OpenAI API key in the settings page to use this feature.',
    'admin_languages.main.language_name' => 'Language',
    'admin_languages.main.language_name_help' => 'The name of the language, such as: French, Italian...etc.',
    'admin_languages.main.language_code' => 'Language code',
    'admin_languages.main.language_code_help' => 'The ISO 639-1 language code, such as: fr, it...etc.',
    'admin_languages.main.language_flag' => 'Flag emoji',
    'admin_languages.main.language_flag_placeholder' => '🇺🇸',
    'admin_languages.main.display' => 'Display type',
    'admin_languages.main.display_translated' => 'Translated',
    'admin_languages.main.display_not_translated' => 'Not translated',
    'admin_languages.main.main' => 'Main language',
    'admin_languages.main.default_language' => 'Default language',
    'admin_languages.info_message.max_input_vars' => 'Your server\'s PHP settings (max_input_vars) allow you to submit %1$s translated fields at one time. <a href="' . PRODUCT_DOCUMENTATION_URL . '" target="_blank">Read the documentation FAQ</a>.',
    'admin_languages.info_message.total' => 'There are currently %1$s/%2$s filled translation strings (%3$s empty translation strings).',
    'admin_languages.info_message.main' => 'The main language will always be replaced with releases of new updates. <a href="' . PRODUCT_DOCUMENTATION_URL . '" target="_blank">Read the documentation FAQ</a>.',
    'admin_languages.error_message.language_exists' => '%1$s (%2$s) language already exists.',
    'admin_languages.error_message.missing_variables' => 'This field is expecting %1$s variable strings but %2$s were given.',


    'admin_language_create.breadcrumb' => 'Create language',
    'admin_language_create.title' => 'Create language',
    'admin_language_create.header' => 'Create language',
    'admin_language_create.subheader' => 'You can translate the new language after it\'s creation.',
    'admin_language_create.menu' => 'Create language',


    'admin_language_update.breadcrumb' => 'Edit language',
    'admin_language_update.title' => 'Edit language',
    'admin_language_update.header' => 'Edit language',


    'admin_statistics.title' => 'Statistics - %s',
    'admin_statistics.menu' => 'Statistics',
    'admin_statistics.header' => 'Statistics',
    'admin_statistics.subheader' => 'See how your website evolves throughout time.',
    'admin_statistics.users' => 'Users',
    'admin_statistics.users.header' => 'Users',
    'admin_statistics.percentage' => 'Percentage',

    'admin_statistics.payments.menu' => 'Payments',
    'admin_statistics.payments.header' => 'Sales',
    'admin_statistics.payments.chart_total_payments' => 'Total sales',
    'admin_statistics.payments.chart_total_amount' => 'Total earned',

    'admin_statistics.redeemed_codes.menu' => 'Redeemed codes',
    'admin_statistics.redeemed_codes.header' => 'Redeemed codes',
    'admin_statistics.redeemed_codes.chart_discount_codes' => 'Discount codes',
    'admin_statistics.redeemed_codes.chart_redeemable_codes' => 'Redeemable codes',

    'admin_statistics.affiliates_commissions.menu' => 'Aff. Commissions',
    'admin_statistics.affiliates_commissions.header' => 'Affiliates commissions',
    'admin_statistics.affiliates_commissions.chart_total_affiliates_commissions' => 'Total affiliates commissions',
    'admin_statistics.affiliates_commissions.chart_amount' => 'Total amount',

    'admin_statistics.affiliates_withdrawals.menu' => 'Aff. Withdrawals',
    'admin_statistics.affiliates_withdrawals.header' => 'Affiliates withdrawals',
    'admin_statistics.affiliates_withdrawals.chart_total_affiliates_withdrawals' => 'Total affiliates withdrawals',
    'admin_statistics.affiliates_withdrawals.chart_amount' => 'Total amount',

    'admin_statistics.database.menu' => 'Database',
    'admin_statistics.database.header' => 'Database',
    'admin_statistics.database.size' => 'Size',
    'admin_statistics.database.rows' => 'Rows',

    'admin_statistics.broadcasts.menu' => 'Broadcasts',
    'admin_statistics.broadcasts.header' => 'New broadcasts',
    'admin_statistics.broadcasts.chart_broadcasts' => 'Broadcasts',
    'admin_statistics.broadcasts.chart_sent_emails' => 'Sent emails',

    'admin_statistics.internal_notifications.menu' => 'Users notifications',
    'admin_statistics.internal_notifications.header' => 'Sent notifications',
    'admin_statistics.internal_notifications.chart_internal_notifications' => 'Sent notifications',
    'admin_statistics.internal_notifications.chart_read_notifications' => 'Read notifications',

    'admin_statistics.teams.menu' => 'Teams',
    'admin_statistics.teams.header' => 'New created teams',
    'admin_statistics.teams.chart' => 'Teams',

    'admin_statistics.teams_members.menu' => 'Teams members',
    'admin_statistics.teams_members.header' => 'New teams members',
    'admin_statistics.teams_members.chart' => 'Teams members',

    'admin_statistics.growth.menu' => 'Growth',
    'admin_statistics.growth.header' => 'Growth',

    'admin_statistics.growth.users.header' => 'New registered users',
    'admin_statistics.growth.users.chart' => 'Users',

    'admin_statistics.growth.users_logs.header' => 'Active users',
    'admin_statistics.growth.users_logs.chart' => 'Active users',


    'admin_statistics.users.menu' => 'Users',
    'admin_statistics.users.sources' => 'Sources',
    'admin_statistics.users.source' => 'Source',
    'admin_statistics.users.plans' => 'Plans',
    'admin_statistics.users.plan' => 'Plan',

    'admin_statistics.stores.menu' => 'Stores',

    'admin_statistics.stores.stores.header' => 'Stores',
    'admin_statistics.stores.stores.chart' => 'New stores',

    'admin_statistics.stores.menus.header' => 'Menus',
    'admin_statistics.stores.menus.chart' => 'New menus',

    'admin_statistics.stores.categories.header' => 'Menu categories',
    'admin_statistics.stores.categories.chart' => 'New categories',

    'admin_statistics.stores.items.header' => 'Menu items',
    'admin_statistics.stores.items.chart' => 'New items',

    'admin_statistics.statistics.menu' => 'Stores statistics',
    'admin_statistics.statistics.header' => 'Stores statistics',
    'admin_statistics.statistics.chart' => 'Pageviews',

    'admin_statistics.domains.menu' => 'Domains',
    'admin_statistics.domains.header' => 'Domains',
    'admin_statistics.domains.chart' => 'New domains',

    'admin_statistics.email_reports.menu' => 'Email reports',
    'admin_statistics.email_reports.header' => 'Email Reports',
    'admin_statistics.email_reports.subheader' => 'How many email reports are sent out per day.',
    'admin_statistics.email_reports.chart' => 'Email reports',

    'admin_api_documentation.menu' => 'API docs',
    'admin_api_documentation.title' => 'Admin API documentation',
    'admin_api_documentation.header' => 'Admin API documentation',
    'admin_api_documentation.subheader' => 'This is the documentation for the available API endpoints, only for the admins, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',

    'admin_api_documentation.users.header' => 'Users',
    'admin_api_documentation.users.update.status' => '0 - Disabled, 1 - Active, 2 - Banned',
    'admin_api_documentation.users.update.type' => '0 - Normal user, 1 - Admin',
    'admin_api_documentation.users.update.plan_id' => '\'free\', or an integer plan_id',
    'admin_api_documentation.users.update.plan_expiration_date' => 'Y-m-d H:i:s format in UTC timezone',
    'admin_api_documentation.users.update.plan_trial_done' => '0 - No, 1 - Yes',
    'admin_api_documentation.users.one_time_login_code_header' => 'Generate a one time login code',
    'admin_api_documentation.plans.header' => 'Plans',
    'admin_api_documentation.domains.header' => 'Domains',


    'admin_bulk_delete_modal.header' => 'Delete in bulk',
    'admin_bulk_delete_modal.subheader' => 'You\'ve selected multiple entries to be deleted, this may take a while & it action cannot be undone.',
    'admin_bulk_delete_modal.success_message' => 'The bulk deletion process was performed successfully.',


    'admin_logs.breadcrumb' => 'Logs',
    'admin_logs.title' => 'Logs',
    'admin_logs.header' => 'Logs',
    'admin_logs.menu' => 'Logs',
    'admin_logs.main.size' => 'Size',
    'admin_logs.main.last_modified' => 'Last modified',
    'admin_logs.total' => '%s log files this month',


    'admin_log.breadcrumb' => 'Log',
    'admin_log.title' => 'Log - %s',
    'admin_log.header' => '%s Log',


    'admin_broadcasts.breadcrumb' => 'Broadcasts',
    'admin_broadcasts.title' => 'Broadcasts',
    'admin_broadcasts.menu' => 'Broadcasts',
    'admin_broadcasts.header' => 'Broadcasts',
    'admin_broadcasts.header_no_data' => 'Create your broadcast',
    'admin_broadcasts.subheader_no_data' => 'Send your first newsletter or marketing email to your users with ease.',
    'admin_broadcasts.create' => 'Create broadcast',
    'admin_broadcasts.main.broadcast' => 'Broadcast',
    'admin_broadcasts.main.name_help' => 'Name used for internal purposes only, it is not public in the email broadcast.',
    'admin_broadcasts.main.subject' => 'Subject',
    'admin_broadcasts.main.subject_help' => 'The title of the email. It is recommended you do not use more than 9 words / 60 characters.',
    'admin_broadcasts.main.is_system_email' => 'Is system email',
    'admin_broadcasts.main.is_system_email_help' => 'Your users will get the email with the purpose of it being a mandatory notification email and not for marketing (such as privacy policy changes, security updates...etc).',
    'admin_broadcasts.main.segment' => 'Segment',
    'admin_broadcasts.main.segment_help' => 'Select the group of users that you want to send the email to.',
    'admin_broadcasts.main.segment_help2' => 'We recommend you do not send marketing emails to users who did not actively subscribed to your newsletter.',
    'admin_broadcasts.main.segment.all' => 'All users',
    'admin_broadcasts.main.segment.subscribers' => 'Subscribers',
    'admin_broadcasts.main.segment.custom' => 'Custom',
    'admin_broadcasts.main.segment.filter' => 'Filter',
    'admin_broadcasts.main.segment.filter.is_newsletter_subscribed' => 'Is subscribed?',
    'admin_broadcasts.main.segment.filter.plans' => 'Plans',
    'admin_broadcasts.main.users_ids' => 'Users IDs',
    'admin_broadcasts.main.users_ids_placeholder' => '1,2,3',
    'admin_broadcasts.main.users_ids_help' => 'Comma separated values.',
    'admin_broadcasts.main.content' => 'Content',
    'admin_broadcasts.main.status.draft' => 'Draft',
    'admin_broadcasts.main.status.processing' => 'Processing',
    'admin_broadcasts.main.status.sent' => 'Sent',
    'admin_broadcasts.main.total_emails' => 'Total emails',
    'admin_broadcasts.main.sent_emails' => 'Sent emails',
    'admin_broadcasts.main.views' => 'Views',
    'admin_broadcasts.main.clicks' => 'Clicks',
    'admin_broadcasts.main.views_tooltip' => 'Tracking only works for users who allow images to display inside their emails.',
    'admin_broadcasts.main.variables' => 'You can use the following dynamic variables: <code>{{WEBSITE_TITLE}}</code>, <code>{{NAME}}</code>, <code>{{EMAIL}}</code>.',
    'admin_broadcasts.main.last_sent_email_datetime' => 'Last sent email %s',
    'admin_broadcasts.main.latest_views' => 'Latest views',


    'admin_broadcast_create.breadcrumb' => 'Create broadcast',
    'admin_broadcast_create.title' => 'Create broadcast',
    'admin_broadcast_create.menu' => 'Create broadcast',
    'admin_broadcast_create.header' => 'Create a new broadcast',
    'admin_broadcast_create.content_placeholder' => 'Your email content goes here..',
    'admin_broadcast_create.info1' => 'You must first make sure your SMTP works properly & that your server is capable to handle the processing.',
    'admin_broadcast_create.info2' => 'Sending bulk emails puts your server under a lot of stress and takes time to process. The system can send 30 emails per cron job run.',
    'admin_broadcast_create.info3' => 'Sending a lot of bulk emails also can damage your domain reputation if its considered spam by the receivers.',
    'admin_broadcast_create.save_draft' => 'Save draft',
    'admin_broadcast_create.send_preview' => 'Send preview',
    'admin_broadcast_create.send_broadcast' => 'Send broadcast',
    'admin_broadcast_create.success_message.preview' => 'Preview email sent to %s',
    'admin_broadcast_create.success_message.save' => '%s broadcast was saved. You can come back later and send it.',
    'admin_broadcast_create.success_message.send' => '%s broadcast will start to be processed.',


    'admin_broadcast_update.breadcrumb' => 'Update broadcast',
    'admin_broadcast_update.title' => 'Update broadcast',
    'admin_broadcast_update.menu' => 'Update broadcast',
    'admin_broadcast_update.header' => 'Update broadcast',
    'admin_broadcast_update.error_message.processing' => 'You can not view or update a broadcast while it is processing.',


    'admin_broadcast_view.breadcrumb' => 'View broadcast',
    'admin_broadcast_view.title' => 'View broadcast',
    'admin_broadcast_view.menu' => 'View broadcast',
    'admin_broadcast_view.header' => 'View broadcast',


    'admin_stores.title' => 'Stores',
    'admin_stores.header' => 'Stores',
    'admin_stores.menu' => 'Stores',

    'admin_stores.table.name' => 'Name',
    'admin_stores.table.stats' => 'Stats',
    'admin_stores.table.pageviews' => '%s pageviews',
    'admin_stores.table.orders' => '%s orders',


    'admin_domains.breadcrumb' => 'Domains',
    'admin_domains.title' => 'Domains',
    'admin_domains.header' => 'Domains',
    'admin_domains.menu' => 'Domains',

    'admin_domains.table.host' => 'Domain',

    'admin_domains.main.helper' => 'Make sure that your domain or subdomain has an A record pointing to %s or CNAME record pointing to %s.',
    'admin_domains.main.scheme' => 'Scheme',
    'admin_domains.main.host' => 'Domain or subdomain',
    'admin_domains.main.host_placeholder' => 'domain.com',
    'admin_domains.main.host_help' => 'Only <code>domain.com</code> and <code>subdomain.domain.com</code> formats are allowed.',
    'admin_domains.main.dns' => 'DNS Values',
    'admin_domains.main.dns_help' => 'These are the DNS values detected at this moment in time.',
    'admin_domains.main.custom_index_url' => 'Custom index url',
    'admin_domains.main.custom_index_url_help' => 'Redirect to a specific url when visitors land on the index of the domain.',
    'admin_domains.main.custom_not_found_url' => 'Custom 404 not found url',
    'admin_domains.main.custom_not_found_url_help' => 'Redirect to a specific url when visitors land on a not found page of the domain.',
    'admin_domains.main.type_global' => 'Global domain',
    'admin_domains.main.type_user' => 'User domain',


    'admin_domain_create.breadcrumb' => 'Add domain',
    'admin_domain_create.title' => 'Add global domain',
    'admin_domain_create.header' => 'Add global domain',
    'admin_domain_create.menu' => 'Add domain',


    'admin_domain_update.breadcrumb' => 'Edit domain',
    'admin_domain_update.title' => 'Edit domain',
    'admin_domain_update.header' => 'Edit domain',
];
