<?php
/*
 * @copyright Copyright (c) 2023 AltumCode (https://altumcode.com/)
 *
 * This software is exclusively sold through https://altumcode.com/ by the AltumCode author.
 * Downloading this product from any other sources and running it without a proper license is illegal,
 *  except the official ones linked from https://altumcode.com/.
 */

return [
    'direction' => 'ltr',

    'global.submit' => 'Submit',
    'global.create' => 'Create',
    'global.delete' => 'Delete',
    'global.edit' => 'Edit',
    'global.view' => 'View',
    'global.duplicate' => 'Duplicate',
    'global.transfer' => 'Transfer',
    'global.reset' => 'Reset',
    'global.share' => 'Share',
    'global.share_via' => 'Share via %s',
    'global.cancel' => 'Cancel',
    'global.update' => 'Update',
    'global.enable' => 'Enable',
    'global.hidden' => 'Hidden',
    'global.login' => 'Login',
    'global.language' => 'Language',
    'global.choose_language' => 'Choose language',
    'global.choose_currency' => 'Choose currency',
    'global.theme_style' => 'Switch to %s Mode',
    'global.theme_style_light' => 'Light',
    'global.theme_style_dark' => 'Dark',
    'global.close' => 'Close',
    'global.search' => 'Search',
    'global.no_data' => 'No data available..',
    'global.unknown' => 'Unknown',
    'global.none' => 'None',
    'global.yes' => 'Yes',
    'global.no' => 'No',
    'global.status' => 'Status',
    'global.active' => 'Active',
    'global.disabled' => 'Disabled',
    'global.all' => 'All',
    'global.order' => 'Order',
    'global.download' => 'Download',
    'global.download_as' => 'Download as %s',
    'global.export' => 'Export',
    'global.export_to' => 'Export to %s',
    'global.captcha_placeholder' => 'Captcha text',
    'global.loading' => 'Loading..',
    'global.view_more' => 'View more',
    'global.view_x_more' => 'View %s more..',
    'global.clipboard_copy' => 'Copy to clipboard',
    'global.clipboard_copied' => 'Copied!',
    'global.terms_and_conditions' => 'Terms and Conditions',
    'global.privacy_policy' => 'Privacy Policy',
    'global.delete_file' => 'Delete uploaded file',
    'global.bulk_actions' => 'Bulk actions',
    'global.unlimited' => 'Unlimited',
    'global.duplicated' => 'Duplicated',
    'global.datetime' => 'Created on',
    'global.last_datetime' => 'Updated on',
    'global.datetime_tooltip' => 'Created on %s',
    'global.last_datetime_tooltip' => 'Updated on %s',
    'global.device' => 'Device',
    'global.device.desktop' => 'Desktop',
    'global.device.tablet' => 'Tablet',
    'global.device.mobile' => 'Mobile',
    'global.continent' => 'Continent',
    'global.continents' => 'Continents',
    'global.country' => 'Country',
    'global.countries' => 'Countries',
    'global.city' => 'City',
    'global.cities' => 'Cities',
    'global.os_name' => 'Operating system',
    'global.browser_name' => 'Browser',
    'global.browser_language' => 'Browser language',
    'global.ip' => 'IP',
    'global.name' => 'Name',
    'global.description' => 'Description',
    'global.email' => 'Email',
    'global.email_placeholder' => 'hello@example.com',
    'global.password' => 'Password',
    'global.user' => 'User',
    'global.icon' => 'Icon',
    'global.icon_placeholder' => 'fas fa-bolt',
    'global.icon_help' => '<a href="https://fontawesome.com/search?o=r&m=free" target="_blank">FontAwesome</a> icon class.',
    'global.url' => 'URL',
    'global.url_placeholder' => 'https://example.com/',
    'global.url_slug_placeholder' => 'example',
    'global.admin_impersonate_user_help' => 'Logged in as',
    'global.admin_impersonate_user_logout' => 'Exit',
    'global.admin_spintax_help' => 'You can also use Spintax format, as such: <code>{Hi|Hey|Hello}</code> to randomize words or phrases.',
    'global.team_delegate_access_help' => 'Logged in as %1$s via %2$s team.',
    'global.team_delegate_access_logout' => 'Exit',
    'global.update_x' => 'Edit %s',
    'global.mb' => 'MB',
    'global.details' => 'Details',
    'global.type' => 'Type',

    'global.info_message.user_plan_is_expired' => 'Your current plan has expired and your access is now limited.',
    'global.info_message.plan_feature_no_access' => 'Your current plan does not allow you to access this feature.',
    'global.info_message.plan_feature_limit' => 'Your have exceeded the limits of your current plan.',
    'global.info_message.plan_feature_limit_info' => '%1$s out of %2$s used <br /> %3$s remaining',
    'global.info_message.team_no_access' => 'Your team access does not allow you to use this feature.',
    'global.info_message.team_limit' => 'Only the team owner can access this page.',

    'global.success_message.create1' => '%s has been successfully created.',
    'global.success_message.create2' => 'Successfully created.',
    'global.success_message.update1' => '%s has been successfully updated.',
    'global.success_message.update2' => 'Successfully updated.',
    'global.success_message.delete1' => '%s has been successfully deleted.',
    'global.success_message.delete2' => 'Successfully deleted.',

    'global.error_message.directory_not_writable' => 'Directory <strong>%s</strong> is not writable. Please set the CHMOD permissions so this folder can be written.',
    'global.error_message.file_not_writable' => 'File <strong>%s</strong> is not writable . Please set the CHMOD permissions so this file can be written.',
    'global.error_message.empty_fields' => 'You must fill all the fields.',
    'global.error_message.empty_field' => 'This field is required, you must fill it.',
    'global.error_message.invalid_file_type' => 'You are not allowed to upload files of this type.',
    'global.error_message.file_upload' => 'Something happened while uploading the file and we could not process it.',
    'global.error_message.invalid_csrf_token' => 'The action could not be finished because the protector has expired, please try again.',
    'global.error_message.basic' => 'We could not perform this action.',
    'global.error_message.file_size_limit' => 'The uploaded file is too big, the maximum file size you are allowed to upload is %s MB.',
    'global.error_message.password_length' => 'The password must be between 6 and 64 characters.',
    'global.error_message.passwords_not_matching' => 'The entered passwords do not match.',
    'global.error_message.invalid_email' => 'The entered email is invalid.',
    'global.error_message.invalid_captcha' => 'The entered captcha code is invalid.',
    'global.error_message.function_required' => '<code>%s</code> is required, but your server does not have it enabled. Contact your server administrator.',
    'global.error_message.limit_try_again' => 'You reached the limit. Try again in %1$s %2$s.',

    'global.menu.logout' => 'Logout',
    'global.menu.admin' => 'Admin',

    'global.accessibility.toggle_navigation' => 'Toggle navigation',
    'global.accessibility.logo_alt' => 'Website Logo',
    'global.accessibility.captcha_alt' => 'Captcha',
    'global.accessibility.captcha_input' => 'Captcha Field',
    'global.accessibility.whitelisted_file_extensions' => '%s allowed.',
    'global.accessibility.file_size_limit' => '%s MB maximum.',
    'global.accessibility.admin_file_size_limit_help' => 'You are not able to set a higher limit than your actual server upload limit.',

    'global.pagination.previous' => 'Previous',
    'global.pagination.next' => 'Next',
    'global.pagination.results' => 'Showing %1$s-%2$s out of %3$s results.',

    'global.filters.header' => 'Filters',
    'global.filters.reset' => 'Reset',
    'global.filters.search' => 'Search',
    'global.filters.search_by' => 'Search by',
    'global.filters.order_by' => 'Order by',
    'global.filters.order_by_datetime' => 'Created datetime',
    'global.filters.order_by_last_datetime' => 'Updated datetime',
    'global.filters.order_type' => 'Order type',
    'global.filters.order_type_asc' => 'Ascending',
    'global.filters.order_type_desc' => 'Descending',
    'global.filters.results_per_page' => 'Results per page',

    'global.date.datetime_readable_format' => '%1$s %2$s, %3$s',
    'global.date.datetime_small_readable_format' => '%1$s %2$s',
    'global.date.datetime_ymd_format' => '%1$s-%2$s-%3$s',
    'global.date.datetime_his_format' => '%1$s:%2$s:%3$s',
    'global.date.datetime_ymd_his_format' => '%1$s-%2$s-%3$s %4$s:%5$s:%6$s',
    'global.date.now' => 'now',
    'global.date.cancel' => 'Cancel',
    'global.date.apply' => 'Apply',
    'global.date.from' => 'From',
    'global.date.to' => 'To',
    'global.date.custom' => 'Custom',
    'global.date.today' => 'Today',
    'global.date.yesterday' => 'Yesterday',
    'global.date.last_7_days' => 'Last 7 days',
    'global.date.last_30_days' => 'Last 30 days',
    'global.date.this_month' => 'This month',
    'global.date.last_month' => 'Last month',
    'global.date.all_time' => 'All time',
    'global.date.short_milliseconds' => 'ms',
    'global.date.short_seconds' => 's',
    'global.date.second' => 'second',
    'global.date.seconds' => 'seconds',
    'global.date.minute' => 'minute',
    'global.date.minutes' => 'minutes',
    'global.date.hour' => 'hour',
    'global.date.hours' => 'hours',
    'global.date.day' => 'day',
    'global.date.days' => 'days',
    'global.date.week' => 'week',
    'global.date.weeks' => 'weeks',
    'global.date.month' => 'month',
    'global.date.months' => 'months',
    'global.date.year' => 'year',
    'global.date.years' => 'years',
    'global.date.time_ago' => '%1$s %2$s ago',
    'global.date.time_until' => '%1$s %2$s',

    'global.date.long_days.1' => 'Monday',
    'global.date.long_days.2' => 'Tuesday',
    'global.date.long_days.3' => 'Wednesday',
    'global.date.long_days.4' => 'Thursday',
    'global.date.long_days.5' => 'Friday',
    'global.date.long_days.6' => 'Saturday',
    'global.date.long_days.7' => 'Sunday',

    'global.date.short_days.1' => 'Mon',
    'global.date.short_days.2' => 'Tue',
    'global.date.short_days.3' => 'Wed',
    'global.date.short_days.4' => 'Thu',
    'global.date.short_days.5' => 'Fri',
    'global.date.short_days.6' => 'Sat',
    'global.date.short_days.7' => 'Sun',

    'global.date.long_months.1' => 'January',
    'global.date.long_months.2' => 'February',
    'global.date.long_months.3' => 'March',
    'global.date.long_months.4' => 'April',
    'global.date.long_months.5' => 'May',
    'global.date.long_months.6' => 'June',
    'global.date.long_months.7' => 'July',
    'global.date.long_months.8' => 'August',
    'global.date.long_months.9' => 'September',
    'global.date.long_months.10' => 'October',
    'global.date.long_months.11' => 'November',
    'global.date.long_months.12' => 'December',

    'global.date.short_months.1' => 'Jan',
    'global.date.short_months.2' => 'Feb',
    'global.date.short_months.3' => 'Mar',
    'global.date.short_months.4' => 'Apr',
    'global.date.short_months.5' => 'May',
    'global.date.short_months.6' => 'Jun',
    'global.date.short_months.7' => 'Jul',
    'global.date.short_months.8' => 'Aug',
    'global.date.short_months.9' => 'Sep',
    'global.date.short_months.10' => 'Oct',
    'global.date.short_months.11' => 'Nov',
    'global.date.short_months.12' => 'Dec',

    'global.number.decimal_point' => '.',
    'global.number.thousands_separator' => ',',

    'global.emails.copyright' => 'Copyright © %1$s %2$s.',
    'global.emails.anti_phishing_code' => 'Anti phishing code: %s',
    'global.emails.is_broadcast' => 'You are receiving this email because you have subscribed to our newsletter broadcasts. You can %sUnsubscribe here%s at any point in time.',

    'global.emails.user_welcome.subject' => 'Welcome to {{WEBSITE_TITLE}}',
    'global.emails.user_welcome.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />We want to salute you and welcome you to our website community!<br /><br /><a href="{{URL}}">Visit our homepage</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_activation.subject' => 'Welcome {{NAME}}! - Activation email',
    'global.emails.user_activation.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />We are glad you joined us! <br /><br />One more step and you are ready,<br /><br />you just need to click the following link in order to join {{WEBSITE_TITLE}}<br /><br /><a href="{{ACTIVATION_LINK}}">Activate your account</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_pending_email.subject' => 'Confirm your email address change - {{WEBSITE_TITLE}}',
    'global.emails.user_pending_email.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />You have requested to change your email address from {{CURRENT_EMAIL}} to {{NEW_EMAIL}}. <br /><br />Please click on the link below to confirm your new email address. <br /><br /><a href="{{ACTIVATION_LINK}}">Confirm email address change</a><br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_lost_password.subject' => 'Reset your password - {{WEBSITE_TITLE}}',
    'global.emails.user_lost_password.body' => 'Hey <strong>{{NAME}}</strong>,<br /><br />This is your reset password link: <a href="{{LOST_PASSWORD_LINK}}">Reset Password</a><br /><br />If you did not request this, you can ignore it!<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_payment.subject' => 'Payment received - {{WEBSITE_TITLE}}',
    'global.emails.user_payment.body' => 'Hey there,<br /><br />This is a confirmation that your payment has been received by us.<br /><br />Your account plan is now paid until {{PLAN_EXPIRATION_DATE}}!<br /><br />You can also check all the <a href="{{USER_PAYMENTS_LINK}}">payments</a> you made, <a href="{{USER_PLAN_LINK}}">change your plan</a> or <a href="{{USER_PLAN_LINK}}">cancel it</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_plan_expiry_reminder.subject' => 'Your plan is expiring in {{DAYS_UNTIL_EXPIRATION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_plan_expiry_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your {{PLAN_NAME}} plan is going to expire in {{DAYS_UNTIL_EXPIRATION}} days.<br /><br />Please <a href="{{USER_PLAN_RENEW_LINK}}">renew your plan</a> if you wish to continue using our website with all the features you have.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_deletion_reminder.subject' => 'Your account will be deleted in {{DAYS_UNTIL_DELETION}} days - {{WEBSITE_TITLE}}',
    'global.emails.user_deletion_reminder.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to remind you that your account is going to be deleted in {{DAYS_UNTIL_DELETION}} days because your account has been inactive.<br /><br />If you wish to cancel this deletion, simply <a href="{{LOGIN_LINK}}">login</a> with your account and the deletion process will be stopped.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.auto_delete_inactive_users.subject' => 'Your account has been deleted - {{WEBSITE_TITLE}}',
    'global.emails.auto_delete_inactive_users.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a simple email to let you know that your account has been deleted because of being inactive for more than {{INACTIVITY_DAYS}} days.<br /><br />If you wish to re-gain access, you would need to <a href="{{REGISTER_LINK}}">register</a> another account with us.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.user_affiliate_withdrawal_approved.subject' => 'Affiliate withdrawal approved - {{WEBSITE_TITLE}}',
    'global.emails.user_affiliate_withdrawal_approved.body' => 'Hey there <strong>{{NAME}}</strong>,<br /><br />This is a confirmation that your recent affiliate withdrawal of <strong>{{AMOUNT}} {{CURRENCY}}</strong> has been approved and your payment was sent for processing.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.team_member_create.subject' => 'You\'ve been invited to \'{{TEAM_NAME}}\' team - {{WEBSITE_TITLE}}',
    'global.emails.team_member_create.body_login' => 'Hey there,<br /><br />You have been invited by <strong>{{USER_NAME}}</strong> ({{USER_EMAIL}}) to join the <strong>{{TEAM_NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{LOGIN_LINK}}">login and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',
    'global.emails.team_member_create.body_register' => 'Hey there,<br /><br />You have been invited by <strong>{{USER_NAME}}</strong> ({{USER_EMAIL}}) to join the <strong>{{TEAM_NAME}}</strong> team on {{WEBSITE_TITLE}}.<br /><br />Click here to <a href="{{REGISTER_LINK}}">register and accept the invitation</a>.<br /><br />Greetings from {{WEBSITE_TITLE}}.',

    'global.emails.admin_new_user_notification.subject' => 'New user registered - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_user_notification.body' => 'A new user just registered to the website!<br /><br />Welcome to <strong>{{NAME}}</strong> ({{EMAIL}}) to your website!',

    'global.emails.admin_delete_user_notification.subject' => 'User deleted his account - {{WEBSITE_TITLE}}',
    'global.emails.admin_delete_user_notification.body' => 'A user just deleted his account from the website!<br /><br />All data of <strong>{{NAME}}</strong> ({{EMAIL}}) has been deleted.',

    'global.emails.admin_new_payment_notification.subject' => 'New payment via {{PROCESSOR}} of {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_payment_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just paid <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> to your website!<br /><br />Here\'s to more earnings!',

    'global.emails.admin_new_affiliate_withdrawal_notification.subject' => 'New affiliate withdrawal request for {{TOTAL_AMOUNT}} {{CURRENCY}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_affiliate_withdrawal_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user just submitted an affiliate withdrawal request for <strong>{{TOTAL_AMOUNT}} {{CURRENCY}}</strong> with the following note: "{{AFFILIATE_WITHDRAWAL_NOTE}}".<br /><br /><a href="{{ADMIN_AFFILIATE_WITHDRAWAL_LINK}}">View affiliate withdrawal</a>',

    'global.emails.admin_new_domain_notification.subject' => 'New custom domain is pending approval - {{WEBSITE_TITLE}}',
    'global.emails.admin_new_domain_notification.body' => '<strong>{{NAME}}</strong> ({{EMAIL}}) user\'s custom domain ({{DOMAIN_HOST}}) is now pending approval.<br /><br /> <a href="{{ADMIN_DOMAIN_UPDATE_LINK}}">View domain</a>',

    'global.emails.admin_contact.subject' => '{{SUBJECT}} - {{NAME}} - {{WEBSITE_TITLE}}',
    'global.emails.admin_contact.body' => '<strong>{{NAME}}</strong> - {{EMAIL}} has sent you the following message:<br /><br />{{MESSAGE}}',


    'global.notifications.new_user.title' => 'New user!',
    'global.notifications.new_user.description' => '<strong>%1$s</strong> (%2$s) has signed up successfully.',

    'global.notifications.delete_user.title' => 'User deleted!',
    'global.notifications.delete_user.description' => '<strong>%1$s</strong> (%2$s) has deleted his account.',

    'global.notifications.new_payment.title' => 'New payment!',
    'global.notifications.new_payment.description' => '<strong>%1$s</strong> (%2$s) user just paid <strong>%3$s %4$s</strong> via %5$s.',

    'global.notifications.new_affiliate_withdrawal.title' => 'New affiliate withdrawal request!',
    'global.notifications.new_affiliate_withdrawal.description' => '<strong>%1$s</strong> (%2$s) user just submitted an affiliate withdrawal request for <strong>%3$s %4$s</strong>.',

    'global.notifications.new_newsletter_subscriber.title' => 'New newsletter subscriber!',
    'global.notifications.new_newsletter_subscriber.description' => '<strong>%1$s</strong> (%2$s) has subscribed successfully.',


    'global.cookie_consent.menu' => 'Cookies',
    'global.cookie_consent.header' => 'We use cookies 🍪',
    'global.cookie_consent.subheader' => 'Hi, this website uses essential cookies to ensure its proper operation and tracking cookies to understand how you interact with it. The latter will be set only after consent. <button type="button" data-cc="c-settings" class="cc-link">Let me choose</button>',
    'global.cookie_consent.modal.preferences.header' => 'Cookie preferences',
    'global.cookie_consent.modal.header' => 'Cookie usage 📢',
    'global.cookie_consent.modal.subheader' => 'We use cookies to ensure the basic functionalities of the website and to enhance your online experience. You can choose for each category to opt-in/out whenever you want. For more details relative to cookies and other sensitive data, please read the full <a href="%s" class="cc-link">privacy policy</a>.',
    'global.cookie_consent.modal.necessary.header' => 'Strictly necessary cookies',
    'global.cookie_consent.modal.necessary.subheader' => 'These cookies are essential for the proper functioning of my website. Without these cookies, the website would not work properly.',
    'global.cookie_consent.modal.analytics.header' => 'Performance and Analytics cookies',
    'global.cookie_consent.modal.analytics.subheader' => 'These cookies allow the website to remember the choices you have made in the past.',
    'global.cookie_consent.modal.targeting.header' => 'Advertisement and Targeting cookies',
    'global.cookie_consent.modal.targeting.subheader' => 'These cookies collect information about how you use the website, which pages you visited and which links you clicked on. All of the data is anonymized and cannot be used to identify you.',
    'global.cookie_consent.accept_all' => 'Accept all',
    'global.cookie_consent.reject_all' => 'Reject all',
    'global.cookie_consent.save' => 'Save settings',
    'global.cookie_consent.close' => 'Close',

    'global.footer.copyright' => 'Copyright &copy; %1$s %2$s.',

    'global.plan_settings.no_ads' => 'No Ads',
    'global.plan_settings.stores_limit' => '%s stores',
    'global.plan_settings.menus_limit' => '%s menus',
    'global.plan_settings.categories_limit' => '%s categories',
    'global.plan_settings.items_limit' => '%s items',
    'global.plan_settings.domains_limit' => '%s custom domains',
    'global.plan_settings.statistics_retention' => '%s days statistics retention',
    'global.plan_settings.ordering_is_enabled' => 'Ordering system',
    'global.plan_settings.additional_domains' => '%s Additional domains',
    'global.plan_settings.additional_domains_help' => 'You get to choose from multiple domains when creating new store. %s',
    'global.plan_settings.password_protection_is_enabled' => 'Password protected stores',
    'global.plan_settings.analytics_is_enabled' => 'Analytics',
    'global.plan_settings.qr_is_enabled' => 'QR code builder',
    'global.plan_settings.removable_branding_is_enabled' => 'Removable branding',
    'global.plan_settings.custom_url_is_enabled' => 'Custom back-half URL',
    'global.plan_settings.search_engine_block_is_enabled' => 'Block Search Engine indexing',
    'global.plan_settings.custom_css_is_enabled' => 'Custom CSS styling',
    'global.plan_settings.custom_js_is_enabled' => 'Custom JS',
    'global.plan_settings.email_reports_is_enabled' => 'Email Reports',
    'global.plan_settings.online_payments_is_enabled' => 'Accept PayPal, Stripe online payments',
    'global.plan_settings.api_is_enabled' => 'API access',
    'global.plan_settings.api_is_enabled_help' => 'Get access to use the REST API.',
    'global.plan_settings.affiliate_commission_percentage' => '%s affiliate percentage',
    'global.plan_settings.affiliate_commission_percentage_help' => 'The percentage amount that you can earn with the affiliate program.',
    'global.plan_settings.teams_limit' => '%s teams',
    'global.plan_settings.team_members_limit' => '%s team members',


    'pwa_install.header' => 'Install our app 🪄',
    'pwa_install.subheader.desktop' => 'Click on the <code>%s</code> icon in the top right of the address bar.',
    'pwa_install.subheader.android_chrome' => 'Tap on the <code>%s</code> menu and then tap the <code>%s install app</code> menu item.',
    'pwa_install.subheader.ios' => 'Tap on the <code>%s</code> icon and then tap the <code>%s Add to Home Screen</code> menu item.',
    'pwa_install.subheader.ios_safari' => 'Click on the <code>File > Add to Dock</code> menu item of the browser.',


    'push_notifications_modal.menu' => 'Push notifications',
    'push_notifications_modal.header' => 'Push notifications',
    'push_notifications_modal.subheader' => 'You can subscribe to our web push notifications if you want to receive helpful content and non-spam promotions from us.',
    'push_notifications_modal.subscribe' => 'Subscribe',
    'push_notifications_modal.unsubscribe' => 'Unsubscribe',
    'push_notifications_modal.denied' => 'You have denied or disabled push notifications. You must enable them again from the browser settings in order to be able to subscribe.',
    'push_notifications_modal.incompatible' => 'Your browser window is incompatible with receiving push notifications.',


    'ad_blocker_detector_modal.header' => 'Ad blocker detected',
    'ad_blocker_detector_modal.subheader' => 'We serve ads so we can keep our website running. Please disable your ad blockers.',
    'ad_blocker_detector_modal.button' => 'I\'ve disabled the ad blocker',


    'duplicate_modal.header' => 'Duplicate',
    'duplicate_modal.subheader' => 'Easily duplicate this resource with a click of a button.',


    'delete_modal.header' => 'Delete',
    'delete_modal.subheader1' => 'Deleting <strong>%s</strong> cannot be undone.',
    'delete_modal.subheader2' => 'Deleting this cannot be undone.',


    'transfer_modal.header' => 'Transfer ownership',
    'transfer_modal.subheader1' => 'Transfer <strong>%s</strong> to another user account.',
    'transfer_modal.subheader2' => 'Transfer this resource to another user account.',
    'transfer_modal.success_message' => 'The ownership of %1$s has been transferred from %2$s to %3$s',


    'statistics_reset_modal.header' => 'Reset statistics',
    'statistics_reset_modal.subheader' => 'Reset the current selected statistics. This action cannot be undone.',


    's_cart.breadcrumb' => 'Cart',
    's_cart.title' => 'Cart - %s',
    's_cart.menu' => 'My cart',
    's_cart.header' => 'My cart',
    's_cart.name' => 'Full name',
    's_cart.number' => 'Table number',
    's_cart.phone' => 'Phone number',
    's_cart.address' => 'Address',
    's_cart.message' => 'Message',
    's_cart.message_help' => 'Leave empty if you don\'t want to send any custom message.',
    's_cart.type' => 'Ordering type',
    's_cart.type_on_premise' => 'In person',
    's_cart.type_takeaway' => 'Takeaway',
    's_cart.type_delivery' => 'Delivery',
    's_cart.processor' => 'Pay via',
    's_cart.processor_paypal' => 'PayPal',
    's_cart.processor_stripe' => 'Stripe',
    's_cart.processor_mollie' => 'Mollie',
    's_cart.processor_offline_payment' => 'Cash on hand / Card terminal',
    's_cart.item' => 'Item',
    's_cart.price' => 'Price',
    's_cart.remove' => 'Remove',
    's_cart.total' => 'Total',
    's_cart.order' => 'Place order',
    's_cart.quantity' => 'Quantity',
    's_cart.datetime' => 'Date',
    's_cart.order_done' => 'Your order has been sent!',
    's_cart.order_done_help' => 'Thank you!',
    's_cart.order_minimum_value' => 'You must have more than %1$s %2$s in order to send the order.',
    's_cart.ordering_delivery_cost' => 'Delivery fee',
    's_cart.ordering_delivery_cost_help' => 'Spend at least %1$s %2$s and get free delivery.',
    's_cart.no_data' => 'Your cart is empty..',
    's_cart.no_data_help' => 'Start by adding some items to your cart and come back!',

    's_cart.email_orders.title' => 'New order for %1$s - %2$s %3$s',
    's_cart.email_orders.p1' => 'Congratulations, you\'ve got a new order!',
    's_cart.email_orders.button' => 'View order #%s',
    's_cart.email_orders.notice' => 'You are getting these emails because you have enabled email order notifications in your %sStore settings%s page.',
    's_cart.payment_name' => '%1$s - Order #%2$s',

    's_store.breadcrumb' => 'Store',
    's_store.menus' => 'Menus',
    's_store.view_menu' => 'View menu',
    's_store.email' => 'Email us',
    's_store.website' => 'Our website',
    's_store.open' => 'Open Now',
    's_store.closed' => 'Closed',

    's_store.password.title' => 'Password protected store',
    's_store.password.header' => 'Password protected store',
    's_store.password.subheader' => 'You must input the correct password to see the content of the store. Your password will be remembered for 30 days.',
    's_store.password.error_message' => 'The store password is incorrect!',
    's_store.share' => 'Share via:',

    's_menu.breadcrumb' => 'Menu',
    's_menu.title' => '%1$s - %2$s',
    's_menu.header' => '%s menu',


    's_category.breadcrumb' => 'Category',
    's_category.title' => '%1$s - %2$s - %3$s',


    's_item.breadcrumb' => 'Item',
    's_item.title' => '%1$s - %2$s - %3$s - %4$s',
    's_item.view' => 'View more details',
    's_item.extras' => 'Extras',
    's_item.variants' => 'Pick & choose',
    's_item.add_to_cart' => 'Add to cart',
    's_item.added_to_cart' => 'Added!',
    's_item.configure' => 'Configure',


    'page.breadcrumb' => 'Page',
    'page.print' => 'Print',
    'page.estimated_reading_time' => '%s read',
    'page.total_views' => '%s views',


    'pages.title' => 'Pages',
    'pages.header' => 'Resources center',
    'pages.subheader' => 'Here you can find useful page resources depending on your needs.',
    'pages.index.breadcrumb' => 'Pages',
    'pages.index.popular_pages' => 'Popular pages',
    'pages.index.pages_categories.header' => 'Categories',
    'pages.index.pages_categories.total_pages' => '%s available pages',
    'pages.pages_category.breadcrumb' => 'Pages category',
    'pages.no_data' => 'There are resources yet',
    'pages.no_data_help' => 'We still got some work to do for our resources section',


    'blog.title' => 'Blog',
    'blog.title_search' => 'Search for \'%s\' - Blog',
    'blog.breadcrumb' => 'Blog',
    'blog.menu' => 'Blog',
    'blog.header' => 'Blog',
    'blog.header_search' => 'Blog - Search for \'%s\'',
    'blog.subheader' => 'Get to learn & understand new things with the help of curated your blog posts.',
    'blog.rss' => 'RSS Feed',
    'blog.categories' => 'Categories',
    'blog.popular' => 'Popular posts',
    'blog.total_views' => '%s views',
    'blog.estimated_reading_time' => '%s read',
    'blog.blog_post.title' => '%s - Blog',
    'blog.blog_posts_category.title' => '%s - Category - Blog',
    'blog.no_data' => 'There are no blog posts yet',
    'blog.no_data_help' => 'We still got some writing to do for our blog post',


    'plan.breadcrumb' => 'Choose plan',
    'plan.title' => 'Plan',
    'plan.menu' => 'Pricing',
    'plan.header_new' => 'Choose your plan',
    'plan.subheader_new' => 'Select the most convenient plan for you.',
    'plan.header_renew' => 'Renew or change your plan',
    'plan.subheader_renew' => 'Select one plan to renew or change your subscription.',
    'plan.header_upgrade' => 'Upgrade your plan',
    'plan.subheader_upgrade' => 'Select one package to upgrade your subscription.',

    'plan.custom_plan.monthly' => 'Monthly',
    'plan.custom_plan.annual' => 'Annual',
    'plan.custom_plan.lifetime' => 'Lifetime',

    'plan.button.choose' => 'Choose plan',
    'plan.button.renew' => 'Renew plan',
    'plan.button.trial' => 'Try for %s days',
    'plan.button.contact' => 'Contact us',

    'plan.why.header' => 'Why us?',
    'plan.why.subheader' => '',
    'plan.why.one.header' => 'Customer service',
    'plan.why.one.subheader' => 'Our support team will help you with any questions you may have regarding our service.',
    'plan.why.two.header' => 'Privacy',
    'plan.why.two.subheader' => 'You control all the data that you bring within your account on our website.',
    'plan.why.three.header' => 'Quality',
    'plan.why.three.subheader' => 'We focus on delivering the best experience to you, as we fully understand how valuable time is.',

    'plan.faq.header' => 'Frequently asked questions',
    'plan.faq.one.question' => 'What forms of payment do you accept?',
    'plan.faq.one.answer' => 'We accept payments via credit cards, PayPal & crypto as well.',
    'plan.faq.two.question' => 'Can I cancel my subscription?',
    'plan.faq.two.answer' => 'Yes, you definitely can cancel your subscription and, you will still have access to all the features that you already paid for until the end of paid date range.',
    'plan.faq.three.question' => 'Will I get an invoice?',
    'plan.faq.three.answer' => 'Yes, an invoice will be automatically generated for you after any payments from your account.',
    'plan.faq.four.question' => 'Can I have a refund?',
    'plan.faq.four.answer' => 'We do offer refunds in case something goes wrong or you change your mind, simply contact us if needed.',


    'pay_billing.breadcrumb' => 'Billing',
    'pay_billing.title' => 'Billing',
    'pay_billing.header' => 'Fill in your billing details',
    'pay_billing.subheader' => 'We require your billing details for generating proper invoices & for tax handling, provide valid billing details only.',
    'pay_billing.submit' => 'Update & continue to %s checkout',


    'pay.breadcrumb' => '%s plan',
    'pay.title' => 'Pay - %s',
    'pay.attention_title' => '✨Checkout ready 🔥',
    'pay.plan_details' => 'What you\'ll get',
    'pay.accept' => 'By continuing with your order you confirm that you read, understand & agree to the %1$s and %2$s of the site.',

    'pay.free.free_already' => 'You already have the free plan activated.',
    'pay.free.other_plan_not_expired' => 'Your current plan is not expired yet, you will get the free plan after it expires.',

    'pay.trial.header' => 'Start the %s plan',
    'pay.trial.subheader' => 'You are almost there, no strings attached.',
    'pay.trial.trial_start' => 'Start my %s days trial',
    'pay.trial.trial_skip' => 'Skip trial',

    'pay.custom_plan.header' => 'Purchase the %s plan',
    'pay.custom_plan.subheader' => 'You are almost there, complete the following form and checkout.',
    'pay.custom_plan.paypal' => 'PayPal',
    'pay.custom_plan.stripe' => 'Stripe',
    'pay.custom_plan.offline_payment' => 'Offline payment',
    'pay.custom_plan.coinbase' => 'Coinbase',
    'pay.custom_plan.payu' => 'PayU',
    'pay.custom_plan.iyzico' => 'Iyzico',
    'pay.custom_plan.paystack' => 'Paystack',
    'pay.custom_plan.razorpay' => 'Razorpay',
    'pay.custom_plan.mollie' => 'Mollie',
    'pay.custom_plan.yookassa' => 'Yookassa',
    'pay.custom_plan.crypto_com' => 'Crypto.com',
    'pay.custom_plan.paddle' => 'Paddle',
    'pay.custom_plan.mercadopago' => 'MercadoPago',
    'pay.custom_plan.midtrans' => 'Midtrans',
    'pay.custom_plan.flutterwave' => 'Flutterwave',
    'pay.custom_plan.payment_frequency' => 'Payment frequency',
    'pay.custom_plan.monthly' => 'Monthly Payments',
    'pay.custom_plan.annual' => 'Annual Payments',
    'pay.custom_plan.annual_savings' => '%1$s %2$s',
    'pay.custom_plan.lifetime' => 'Lifetime deal',
    'pay.custom_plan.lifetime_help' => 'One time payment',
    'pay.custom_plan.code_button' => 'I have a discount/redeemable code',
    'pay.custom_plan.code' => 'Code',
    'pay.custom_plan.payment_processor' => 'Payment method',
    'pay.custom_plan.no_processor' => 'There are no payment processors available at the moment.',
    'pay.custom_plan.offline_payment_instructions' => 'Payment instructions',
    'pay.custom_plan.offline_payment_proof' => 'Proof of payment',
    'pay.custom_plan.payment_type' => 'Type of payment',
    'pay.custom_plan.one_time_type' => 'One Time Payment',
    'pay.custom_plan.recurring_type' => 'Recurring Payment',

    'pay.custom_plan.summary.header' => 'Order summary',
    'pay.custom_plan.summary.plan' => 'Plan',
    'pay.custom_plan.summary.payment_frequency' => 'Frequency',
    'pay.custom_plan.summary.monthly' => 'Monthly',
    'pay.custom_plan.summary.monthly_help' => 'Every 30 days',
    'pay.custom_plan.summary.annual' => 'Yearly',
    'pay.custom_plan.summary.annual_help' => 'Every 365 days',
    'pay.custom_plan.summary.lifetime' => 'Lifetime',
    'pay.custom_plan.summary.lifetime_help' => '',
    'pay.custom_plan.summary.payment_processor' => 'Paid with',
    'pay.custom_plan.summary.payment_type' => 'Type',
    'pay.custom_plan.summary.one_time' => 'One time',
    'pay.custom_plan.summary.one_time_help' => '',
    'pay.custom_plan.summary.recurring' => 'Recurring',
    'pay.custom_plan.summary.recurring_help' => 'Automatic billing',
    'pay.custom_plan.summary.plan_price' => 'Price',
    'pay.custom_plan.summary.discount' => 'Discount',
    'pay.custom_plan.summary.tax_inclusive' => 'Inclusive',
    'pay.custom_plan.summary.tax_exclusive' => 'Exclusive',
    'pay.custom_plan.summary.total' => 'Total',
    'pay.custom_plan.pay' => 'Checkout',
    'pay.custom_plan.code_redeemable' => 'Redeem %s days for free.',

    'pay.success_message.code' => 'Applied code for %s.',

    'pay.error_message.code_invalid' => 'This code is invalid..',
    'pay.error_message.code_used' => 'You have already used this code..',
    'pay.error_message.canceled_payment' => 'It seems you\'ve canceled the payment for some reason.',
    'pay.error_message.failed_payment' => 'Something didn\'t work quite right, please try again and if this persists contact the site admin.',
    'pay.error_message.offline_payment_proof_missing' => 'You must upload a payment proof before submitting the payment order.',

    'pay_thank_you.title' => 'Thank you',
    'pay_thank_you.header' => 'Thank you!',
    'pay_thank_you.button' => 'Go to my dashboard',
    'pay_thank_you.plan_trial_start' => 'Your %s day trial period just started!',
    'pay_thank_you.plan_redeemed' => 'You redeemed %s days!',
    'pay_thank_you.plan_custom_will_start' => 'Your payment was sent and your new membership will be activated!',
    'pay_thank_you.plan_custom_pending' => 'Your payment order was sent and your new membership will be activated if the proof will be accepted!',

    'account.title' => 'Account',
    'account.menu' => 'Account',

    'account.plan.header' => '%s Plan',
    'account.plan.subheader' => 'ends on %s',
    'account.plan.upgrade_plan' => 'Upgrade Plan',
    'account.plan.renew_plan' => 'Renew/Change Plan',

    'account.settings.header' => 'Settings',
    'account.settings.subheader' => 'Basic profile settings of your account.',
    'account.settings.timezone' => 'Timezone',
    'account.settings.timezone_help' => 'Your preferred way of displaying dates.',
    'account.settings.anti_phishing_code' => 'Anti phishing code',
    'account.settings.anti_phishing_code_help' => 'You\'ll get this code on each email that we send you, so you\'ll know it\'s a valid email from us.',
    'account.settings.is_newsletter_subscribed' => 'Newsletter subscribed',
    'account.settings.is_newsletter_subscribed_help' => 'Receive a few emails per month with updates & discount campaigns we may run. We won\'t spam you.',
    'account.settings.referral_key' => 'Referral key',

    'account.billing.header' => 'Billing details',
    'account.billing.subheader' => 'These billing details are used when generating invoices after a successful payment.',
    'account.billing.subscription_id_active' => 'You have an active subscription, you can\'t change the billing details until the subscription expires or is cancelled.',
    'account.billing.type' => 'Type',
    'account.billing.type_personal' => 'Personal',
    'account.billing.type_business' => 'Business',
    'account.billing.name' => 'Name',
    'account.billing.address' => 'Address',
    'account.billing.county' => 'County',
    'account.billing.zip' => 'ZIP',
    'account.billing.phone' => 'Phone',
    'account.billing.tax_id' => 'Tax ID',
    'account.billing.notes' => 'Additional notes',
    'account.billing.notes_help' => 'Here you can write additional data that you want to have on your invoices.',

    'account.change_password.header' => 'Change password',
    'account.change_password.subheader' => 'If you do not want to change your password, do not fill any of those fields below.',
    'account.change_password.current_password' => 'Current password',
    'account.change_password.current_password_help' => 'If you do not know your current password, you mut logout and use the lost password functionality to reset it.',
    'account.change_password.new_password' => 'New password',
    'account.change_password.repeat_password' => 'Repeat password',

    'account.twofa.header' => 'Two-factor authentication',
    'account.twofa.subheader' => 'Use a mobile authentication app to get a verification code to enter every time you log in.',
    'account.twofa.is_enabled' => 'Enable Two-factor authentication',
    'account.twofa.qr' => '1. Scan QR Code',
    'account.twofa.qr_help' => 'Open the authentication app (ex: Authy, Google Authenticator) on your mobile device and scan the following QR Code with your camera.',
    'account.twofa.secret' => 'Can\'t scan the QR Code?',
    'account.twofa.secret_help' => 'Try inserting the following secret code into your app if you can\'t scan the QR Code.',
    'account.twofa.verify' => '2. Enter freshly generated token',
    'account.twofa.verify_help' => 'To confirm that you setup your code properly, please enter the 6-digit token from your mobile app.',

    'account.info_message.user_pending_email' => 'An email confirmation was sent to the new email address. Make sure to check and confirm it via email.',
    'account.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account.error_message.twofa_check' => 'The token that you entered is not valid, please try again to setup the Two-factor authentication system.',
    'account.error_message.referral_key_exists' => 'This referral key is already in use.',
    'account.success_message.account_updated' => 'Your account was updated.',
    'account.success_message.password_updated' => 'Your account password was updated.',


    'account_delete.title' => 'Delete account',
    'account_delete.menu' => 'Delete account',
    'account_delete.header' => 'Delete account',
    'account_delete.subheader' => 'By deleting the account, all of your stored data will be deleted. This action is irreversible once done.',
    'account_delete.current_password' => 'Current Password',
    'account_delete.error_message.invalid_current_password' => 'Your current password is not valid.',
    'account_delete.success_message' => 'Your account was fully deleted. We\'re sorry to see you go.',


    'account_redeem_code.title' => 'Redeem code',
    'account_redeem_code.menu' => 'Redeem code',
    'account_redeem_code.header' => 'Redeem code',
    'account_redeem_code.subheader' => 'If you own a redeeming code for a particular plan, you can redeem it right here.',
    'account_redeem_code.plan_id' => 'Plan',
    'account_redeem_code.code' => 'Code',
    'account_redeem_code.success_message' => 'You redeemed %1$s days of the %2$s plan.',
    'account_redeem_code.info_message' => 'Your current plan will be overwritten if you redeem a code that is different than your already existing plan.',
    'account_redeem_code.error_message.code_invalid' => 'This code is invalid.',
    'account_redeem_code.error_message.code_used' => 'You have already used this code.',


    'domains.breadcrumb' => 'Custom domains',
    'domains.title' => 'Custom domains',
    'domains.menu' => 'Custom domains',
    'domains.header' => 'Custom domains',
    'domains.subheader' => 'Here you can add your own custom domain to use with your stores.',
    'domains.create' => 'Connect custom domain',

    'domains.table.host' => 'Domain',
    'domains.table.is_enabled_pending' => 'Pending',
    'domains.table.is_enabled_active' => 'Active',

    'domains.input.help' => 'Your domain or subdomain must have an A record pointing to %1$s or CNAME record pointing to %2$s.',
    'domains.input.host' => 'Domain or subdomain',
    'domains.input.host_placeholder' => 'domain.com',
    'domains.input.custom_index_url' => 'Custom index URL',
    'domains.input.custom_index_url_help' => 'Redirect to a specific URL when visitors land on the index of the domain, in case you don\'t want to use the custom domain for a single store.',
    'domains.input.custom_not_found_url' => 'Custom 404 not found URL',
    'domains.input.custom_not_found_url_help' => 'Redirect to a specific URL when visitors land on a not found page of the domain.',
    'domains.no_data' => 'There are no custom domains added',
    'domains.no_data_help' => 'Start by linking your first custom domain.',
    'domains.error_message.host_exists' => 'This custom domain already exists.',


    'domain_create.breadcrumb' => 'Connect custom domain',
    'domain_create.title' => 'Connect custom domain',
    'domain_create.menu' => 'Connect custom domain',
    'domain_create.header' => 'Connect custom domain',
    'domain_create.success_message' => 'Your custom domain has been submitted for approval and processing.',


    'domain_update.breadcrumb' => 'Edit custom domain',
    'domain_update.title' => 'Edit custom domain',
    'domain_update.menu' => 'Edit custom domain',
    'domain_update.header' => 'Edit custom domain',
    'domain_update.success_message' => 'Your custom domain update has been submitted for approval and processing.',


    'domain_delete_modal.header' => 'Delete domain',
    'domain_delete_modal.subheader' => 'By deleting the domain, all the data associated with the domain will be lost, including all the stores associated with it. This action cannot be undone.',


    'account_plan.title' => 'Account Plan',
    'account_plan.menu' => 'Plan',
    'account_plan.header' => 'Account Plan',

    'account_plan.plan.renews' => 'Plan will renew on %1$s via %2$s (%3$s %4$s)',
    'account_plan.plan.expires' => 'Plan ends on %s',

    'account_plan.cancel.header' => 'Cancel Subscription',
    'account_plan.cancel.subheader' => 'By cancelling your subscription no further payments will be made. You will still have access to your features that you paid for until the expiration date.',
    'account_plan.cancel.cancel' => 'Cancel Subscription',
    'account_plan.cancel.confirm_message' => 'Are you sure you want to cancel your subscription?',
    'account_plan.cancel.reason' => 'Cancelled from %s',

    'account_plan.success_message.subscription_canceled' => 'Your recurring subscription was canceled.',

    'account_payments.title' => 'Account payments',
    'account_payments.menu' => 'Payments',
    'account_payments.header' => 'Account payments',
    'account_payments.subheader' => 'All the payments made on your account.',

    'account_payments.payments.payment_processor' => 'Processor',
    'account_payments.payments.total_amount' => 'Total amount',
    'account_payments.payments.plan_id' => 'Plan',
    'account_payments.payments.invoice' => 'Invoice',
    'account_payments.payments.status_pending' => 'Pending approval',
    'account_payments.payments.status_approved' => 'Approved',
    'account_payments.payments.no_data' => 'No payments for now..',

    'account_payments.filters.processor' => 'Processor',
    'account_payments.filters.type_one_time' => 'One time',
    'account_payments.filters.type_recurring' => 'Recurring',
    'account_payments.filters.frequency' => 'Frequency',
    'account_payments.filters.frequency_monthly' => 'Monthly',
    'account_payments.filters.frequency_annual' => 'Annual',
    'account_payments.filters.frequency_lifetime' => 'Lifetime',
    'account_payments.filters.order_by_total_amount' => 'Total amount',

    'account_logs.title' => 'Account logs',
    'account_logs.menu' => 'Logs',
    'account_logs.header' => 'Account logs',
    'account_logs.subheader' => 'A list of your most important recorded activity.',

    'account_logs.logs.no_data' => 'Your account has no recorded logs..',
    'account_logs.logs.no_data_help' => 'Here you will be able to find important log entries regarding your account.',


    'account_api.title' => 'Account API',
    'account_api.menu' => 'API',
    'account_api.header' => 'API',
    'account_api.subheader' => 'Do not share your API key with unauthorized people.',
    'account_api.api_key' => 'API Key',
    'account_api.button' => 'Regenerate API Key',
    'account_api.success_message' => 'Your API key was regenerated successfully.',


    'teams_system.title' => 'Teams system',
    'teams_system.menu' => 'Teams system',
    'teams_system.breadcrumb' => 'Teams system',
    'teams_system.header' => 'Teams system',


    'teams.title' => 'My teams',
    'teams.menu' => 'My teams',
    'teams.breadcrumb' => 'My teams',
    'teams.header' => ' My teams',
    'teams.subheader' => 'Create, invite and manage your teams.',
    'teams.create' => 'Create team',
    'teams.table.members' => 'Members',
    'teams.no_data' => 'There are no teams available',
    'teams.no_data_help' => 'Start by creating your first team & invite people.',


    'team.breadcrumb' => 'Team',
    'team.title' => 'Team - %s',
    'team.header' => '%s team',


    'team_create.breadcrumb' => 'Create team',
    'team_create.title' => 'Create team',
    'team_create.header' => 'Create team',


    'team_update.breadcrumb' => 'Update team',
    'team_update.title' => 'Update team',
    'team_update.header' => 'Update team',


    'team_members.create' => 'Invite member',
    'team_members.input.access' => 'Access',
    'team_members.input.access_help' => 'Set what permissions you want to hand out to the user.',
    'team_members.input.access.read' => 'View',
    'team_members.input.access.create' => 'Create',
    'team_members.input.access.update' => 'Update',
    'team_members.input.access.delete' => 'Delete',
    'team_members.table.member' => 'Member',
    'team_members.table.status_invited' => 'Invited',
    'team_members.table.status_accepted' => 'Accepted',
    'team_members.table.datetime' => 'Invited on',
    'team_members.info_message.access' => 'The invited user will not have access to any account related pages, such as the account settings, payments, logs...etc.',
    'team_members.error_message.email_exists' => 'This email is already invited.',
    'team_members.no_data' => 'There are no team members available',
    'team_members.no_data_help' => 'Start by inviting your first member.',


    'team_member_create.breadcrumb' => 'Invite team member',
    'team_member_create.title' => 'Invite team member - %s',
    'team_member_create.header' => 'Invite team member',
    'team_member_create.submit' => 'Invite via Email',
    'team_member_create.success_message' => '%s has been successfully invited.',


    'team_member_update.breadcrumb' => 'Update team member',
    'team_member_update.title' => 'Update team member - %s',
    'team_member_update.header' => 'Update team member',


    'teams_member.title' => 'Teams member',
    'teams_member.menu' => 'Teams member',
    'teams_member.breadcrumb' => 'Teams member',
    'teams_member.header' => ' Teams member',
    'teams_member.subheader' => 'Manage the teams you\'re invited / a member of.',
    'teams_member.table.team' => 'Team',
    'teams_member.table.datetime' => 'Invited on',
    'teams_member.no_data' => 'There are no teams available',
    'teams_member.no_data_help' => 'You\'re not invited to any team yet.',


    'teams_member_delete_modal.header' => 'Leave team',
    'teams_member_delete_modal.subheader' => 'This action cannot be undone.',


    'teams_member_join_modal.menu' => 'Join team',
    'teams_member_join_modal.header' => 'Join team',
    'teams_member_join_modal.subheader' => 'Accept & join the invitation of the team.',


    'teams_member_login_modal.menu' => 'Login',
    'teams_member_login_modal.header' => 'Login team',
    'teams_member_login_modal.subheader' => 'Log into the team and start managing it.',


    'referrals.title' => 'Referrals',
    'referrals.menu' => 'Referrals',

    'referrals.invite.header' => 'Invite people',
    'referrals.invite.subheader_once' => 'Invite people to %s with the following link and get %s from their first payment to the platform.',
    'referrals.invite.subheader_forever' => 'Invite people to %s with the following link and get %s from all their payments to the platform.',
    'referrals.invite.referral_key' => 'Referral link',
    'referrals.invite.referral_key_help' => 'You can add the %s parameter to any link of our website.',

    'referrals.statistics.header' => 'Statistics',
    'referrals.statistics.referrals' => 'Referrals',
    'referrals.statistics.referrals_help' => 'People who have signed up using your referral link.',
    'referrals.statistics.converted_referrals' => 'Paying referrals',
    'referrals.statistics.converted_referrals_help' => 'People who have signed up & paid for a plan at least once.',
    'referrals.statistics.pending_affiliate_commissions' => 'Pending commissions',
    'referrals.statistics.pending_affiliate_commissions_help' => 'All payments are held for 30 days for proper confirmation before they are approved.',
    'referrals.statistics.approved_affiliate_commissions' => 'Approved commissions',
    'referrals.statistics.approved_affiliate_commissions_help' => 'All payments that have been approved, which are ready to be withdrawn.',

    'referrals.withdraw.header' => 'Withdraw',
    'referrals.withdraw.subheader' => 'Once you reach at least %s, you can create a withdrawal request.',
    'referrals.withdraw.amount' => 'Amount',
    'referrals.withdraw.is_paid_paid' => 'Paid',
    'referrals.withdraw.is_paid_pending' => 'Pending',
    'referrals.withdraw.success_message' => 'Your withdrawal request has been sent for approval and processing.',


    'sso.menu' => 'Go to %s',


    'invoice.title' => 'Invoice %s',
    'invoice.print' => 'Print',
    'invoice.invoice' => 'Invoice',
    'invoice.invoice_nr' => 'Invoice Nr',
    'invoice.invoice_date' => 'Date',
    'invoice.vendor' => 'Vendor',
    'invoice.customer' => 'Customer',
    'invoice.notes' => 'Additional notes',
    'invoice.name' => 'Name',
    'invoice.address' => 'Address',
    'invoice.county' => 'County',
    'invoice.zip' => 'ZIP',
    'invoice.phone' => 'Phone',
    'invoice.tax_id' => 'Tax ID',

    'invoice.table.item' => 'Item',
    'invoice.table.amount' => 'Amount',
    'invoice.table.plan' => '%s Plan',
    'invoice.table.frequency' => '%s access.',
    'invoice.table.frequency_monthly' => '30 days',
    'invoice.table.frequency_annual' => '1 year',
    'invoice.table.frequency_lifetime' => 'Lifetime',
    'invoice.table.code' => 'Discount',
    'invoice.table.code_help' => 'Code used: %s',
    'invoice.table.total' => 'Total',
    'invoice.table.paid_via' => 'Paid via %s',


    'store_invoice.menu' => 'View invoice',
    'store_invoice.order_number' => 'Order number #%s',


    'login.menu' => 'Sign in',
    'login.title' => 'Sign in',
    'login.header' => 'Sign in',

    'login.form.twofa_token' => 'Two-factor token',
    'login.form.remember_me' => 'Remember me',
    'login.form.login' => 'Login',
    'login.form.verify' => 'Verify',

    'login.display.register' => 'Don\'t have an account? %s',
    'login.display.register_help' => 'Register',
    'login.display.lost_password' => 'Lost Password',
    'login.display.resend_activation' => 'Resend Activation',
    'login.display.facebook' => 'Sign in with Facebook',
    'login.display.google' => 'Sign in with Google',
    'login.display.twitter' => 'Sign in with X',
    'login.display.discord' => 'Sign in with Discord',
    'login.display.linkedin' => 'Sign in with LinkedIn',
    'login.display.microsoft' => 'Sign in with Microsoft',

    'login.info_message.twofa_token' => 'Two-factor authentication is required.',
    'login.info_message.logged_in' => 'Welcome back, %s.',
    'login.error_message.twofa_token' => 'Your two-factor authentication token is invalid.',
    'login.error_message.wrong_login_credentials' => 'Your login combination is invalid.',
    'login.error_message.user_not_active' => 'Your account is not confirmed or banned.',
    'login.error_message.email_is_null' => 'Your social account doesn\'t have an email associated with it.',


    'lost_password.title' => 'Lost password',
    'lost_password.header' => 'Lost password',
    'lost_password.subheader' => 'We will send you an email with a magic recovery link to reset your password.',
    'lost_password.return' => 'Return to Login',
    'lost_password.submit' => 'Send me a recovery link',
    'lost_password.success_message' => 'We\'ve sent you an email if there is an account registered with it.',


    'resend_activation.title' => 'Resend activation',
    'resend_activation.header' => 'Resend activation email',
    'resend_activation.subheader' => 'Mails can get lost, but we can send you another activation email for your account.',
    'resend_activation.return' => 'Return to Login',
    'resend_activation.submit' => 'Send me the activation email',
    'resend_activation.success_message' => 'We\'ve sent you an email if there is an account registered with it.',


    'reset_password.title' => 'Set a new password',
    'reset_password.header' => 'Set a new password',
    'reset_password.subheader' => 'For better security, make sure your new password is strong.',
    'reset_password.return' => 'Return to Login',
    'reset_password.new_password' => 'New password',
    'reset_password.repeat_password' => 'Repeat your new password',
    'reset_password.submit' => 'Set password',
    'reset_password.success_message' => 'Your new password is set.',


    'activate_user.user_activation' => 'Your account has been confirmed and is now active.',
    'activate_user.user_pending_email' => 'Your new email address has been confirmed.',


    'register.title' => 'Sign up',
    'register.menu' => 'Sign up',
    'register.header' => 'Sign up',

    'register.form.repeat_password' => 'Repeat Password',
    'register.form.accept' => 'I confirm that I have read and understood the %1$s and %2$s of the site.',
    'register.form.is_newsletter_subscribed' => 'I agree receive a few emails per month from the newsletter. You can unsubscribe at any time.',
    'register.form.register' => 'Register',

    'register.display.login' => 'Already have an account? %s',
    'register.display.login_help' => 'Sign in',

    'register.error_message.name_length' => 'Name must be between 1 and 64 characters.',
    'register.error_message.email_exists' => 'This email address is already in use.',
    'register.error_message.blacklisted_domain' => 'This email domain has been blacklisted.',
    'register.error_message.blacklisted_country' => 'Your country has been blacklisted.',
    'register.success_message.registration' => 'Check your email for the activation link of your account.',
    'register.success_message.login' => 'Welcome to our platform, we are grateful to have you here.',


    'dashboard.breadcrumb' => 'Dashboard',
    'dashboard.title' => 'Dashboard',
    'dashboard.menu' => 'Dashboard',
    'dashboard.header' => 'Dashboard',
    'dashboard.stores_total' => 'Total stores',
    'dashboard.orders_total' => 'Total orders',
    'dashboard.stores_pageviews' => 'Total pageviews',
    'dashboard.filters.name' => 'Name',
    'dashboard.filters.pageviews' => 'Pageviews',
    'dashboard.filters.orders' => 'Orders',
    'dashboard.no_data' => 'There are no created stores',
    'dashboard.no_data_help' => 'Start by creating your first store.',


    'statistics.breadcrumb' => 'Statistics',
    'statistics.title' => '%s - Statistics',
    'statistics.menu' => 'Statistics',
    'statistics.header' => '%s statistics',
    'statistics.pageviews' => 'Pageviews',
    'statistics.visitors' => 'Visitors',

    'statistics.statistics.overview' => 'Overview',
    'statistics.statistics.overview_help' => '',
    'statistics.statistics.entries' => 'Entries',
    'statistics.statistics.entries_help' => 'All the entries that have been logged in a compact list.',
    'statistics.statistics.latest' => 'Latest entries',
    'statistics.statistics.country_help' => 'Discover the countries that your visitors are from.',
    'statistics.statistics.city_name_from_country' => 'Cities of %s',
    'statistics.statistics.city_name_help' => 'Discover the cities that your visitors are from.',
    'statistics.statistics.os' => 'Operating systems',
    'statistics.statistics.os_help' => 'Discover the operating systems that your visitors are using.',
    'statistics.statistics.browser' => 'Browsers',
    'statistics.statistics.browser_help' => 'Discover the browsers that your visitors are using.',
    'statistics.statistics.language' => 'Languages',
    'statistics.statistics.language_help' => 'Discover the browser languages that your visitors are having.',
    'statistics.statistics.device' => 'Devices',
    'statistics.statistics.device_help' => 'Discover the devices that your visitors are using.',
    'statistics.statistics.referrer_host' => 'Referrers',
    'statistics.statistics.referrer_path' => '%s referrer paths',
    'statistics.statistics.referrer_help' => 'Discover where your traffic is coming from.',
    'statistics.statistics.referrer_direct' => 'Direct',
    'statistics.statistics.referrer_qr' => 'QR Code',
    'statistics.statistics.utms' => 'UTMs',
    'statistics.statistics.utms_help' => 'Discover how your UTM marketing campaigns are performing.',
    'statistics.statistics.utm_medium' => '%s utm mediums',
    'statistics.statistics.utm_campaign' => '%s / %s utm sources',
    'statistics.table.os' => 'OS',
    'statistics.table.device' => 'Device',
    'statistics.table.browser' => 'Browser',
    'statistics.table.referrer' => 'Referrer',
    'statistics.no_data' => 'There are no statistics available for this date range',
    'statistics.no_data_help' => 'Wait until you get some traffic and come back.',


    'orders_statistics.breadcrumb' => 'Orders statistics',
    'orders_statistics.title' => '%s - Orders statistics',
    'orders_statistics.menu' => 'Orders statistics',
    'orders_statistics.header' => '%s orders statistics',
    'orders_statistics.ordered_items_label' => 'Ordered items',
    'orders_statistics.value_label' => 'Value',
    'orders_statistics.ordered_items' => 'Top most ordered items',
    'orders_statistics.ordered_items_help' => 'Find the hottest items on your menu.',
    'orders_statistics.orders' => '%s orders',
    'orders_statistics.no_data' => 'There are no statistics available for this date range',
    'orders_statistics.no_data_help' => 'Wait until you get more orders and come back.',


    'stores.title' => 'Stores',
    'store.breadcrumb' => 'Store',
    'store.title' => '%s - Store',
    'store.menu' => 'Store',
    'store.header' => '%s store',
    'store.create' => 'Create store',
    'store.external_url' => 'View store',
    'store.orders_label' => 'Orders',
    'store.value_label' => 'Value',
    'store.stores' => 'Stores',
    'store.timezone' => '%s timezone',
    'store.currency' => '%s currency',
    'store.orders' => '%s orders',
    'store.conversion_rate' => '%s conversion rate',
    'store.datetime' => 'Created on %s',
    'store.pageviews' => '%s Pageviews',

    'store.input.domain_id' => 'Domain',
    'store.input.domain_id_help' => 'Select the domain that you\'d like to use to create your store with.',
    'store.input.is_main_store' => 'Exclusive store for this custom domain',
    'store.input.is_main_store_help' => 'Make this store to be accessible via the index of this custom domain. Other stores won\'t be able to be associated with this domain after.',
    'store.input.url' => 'URL Alias',
    'store.input.url_placeholder' => 'my-awesome-store',
    'store.input.url_help' => 'The main URL that your store is going to be able accessed from.',
    'store.input.name' => 'Name',
    'store.input.name_placeholder' => 'My awesome store',
    'store.input.title' => 'Title',
    'store.input.title_help' => 'Short & descriptive title of your store.',
    'store.input.description' => 'Description',
    'store.input.description_help' => 'Short description of your store.',
    'store.input.logo' => 'Logo',
    'store.input.logo_help' => 'Your store\'s logo, recommended 1:1 ratio for the logo.',
    'store.input.favicon' => 'Favicon',
    'store.input.favicon_help' => 'Your store\'s favicon, recommended 1:1 ratio for the favicon.',
    'store.input.image' => 'Cover',
    'store.input.custom_css' => 'Custom CSS',
    'store.input.custom_css_help' => 'Custom CSS to overwrite the already existing store style.',
    'store.input.custom_js' => 'Custom JS',
    'store.input.custom_js_help' => 'You could add your own tracking javascript code to the store, for example.',
    'store.input.email_reports_is_enabled' => 'Email reports',
    'store.input.email_reports_is_enabled_help' => 'Get casual analytics email reports of your store.',
    'store.input.email_orders_is_enabled' => 'Email orders notifications',
    'store.input.email_orders_is_enabled_help' => 'Get email notifications when a new order arrives.',
    'store.input.ordering_on_premise_is_enabled' => 'Enable on premise ordering',
    'store.input.ordering_on_premise_is_enabled_help' => 'Your store guests will be able to order via the menu for on premise orders.',
    'store.input.ordering_on_premise_minimum_value' => 'On premise minimum order value',
    'store.input.ordering_takeaway_is_enabled' => 'Enable takeaway ordering',
    'store.input.ordering_takeaway_is_enabled_help' => 'Your store guests will be able to order via the menu for takeaway orders.',
    'store.input.ordering_takeaway_minimum_value' => 'Takeaway minimum order value',
    'store.input.ordering_delivery_is_enabled' => 'Enable delivery ordering',
    'store.input.ordering_delivery_is_enabled_help' => 'Your store guests will be able to order via the menu for delivered orders.',
    'store.input.ordering_delivery_minimum_value' => 'Delivery minimum order value',
    'store.input.ordering_delivery_cost' => 'Delivery cost',
    'store.input.ordering_delivery_free_minimum_value' => 'Delivery is free if the order value is above',
    'store.input.instructions' => 'Instructions',
    'store.input.paypal' => 'PayPal',
    'store.input.paypal_is_enabled' => 'Enable PayPal payments',
    'store.input.paypal_mode' => 'Mode',
    'store.input.paypal_mode_help' => 'live - production, sandbox - testing purposes',
    'store.input.paypal_client_id' => 'Client Id',
    'store.input.paypal_secret' => 'Secret',
    'store.input.paypal_instructions_1' => 'Go to <a href="https://developer.paypal.com/">PayPal Developer Console</a> and Login to your account after clicking the Log into Dashboard button.',
    'store.input.paypal_instructions_2' => 'Go to REST API apps section and click the Create App button.',
    'store.input.paypal_instructions_3' => 'Add your own details for the new app and create it.',
    'store.input.paypal_instructions_4' => 'Switch to Live by clicking the button near your new App\'s Name.',
    'store.input.paypal_instructions_5' => 'Copy the Client ID and Secret and paste them here accordingly.',
    'store.input.stripe' => 'Stripe',
    'store.input.stripe_is_enabled' => 'Enable Stripe payments',
    'store.input.stripe_publishable_key' => 'Publishable Key',
    'store.input.stripe_secret_key' => 'Secret Key',
    'store.input.stripe_webhook_secret' => 'Webhook Secret',
    'store.input.stripe_instructions_1' => 'Go to <a href="https://dashboard.stripe.com/">Stripe Dashboard</a> and Login to your account..',
    'store.input.stripe_instructions_2' => 'Go to <a href="https://dashboard.stripe.com/account/apikeys">Stripe API Keys</a> page.',
    'store.input.stripe_instructions_3' => 'Make sure your API keys are set to Live Mode so that you can accept real payments.',
    'store.input.stripe_instructions_4' => 'Copy the Publishable key and Secret key and paste them here accordingly.',
    'store.input.stripe_instructions_5' => 'From the sidebar, under Developers click on Webhooks link.',
    'store.input.stripe_instructions_6' => 'Click on the Add endpoint button.',
    'store.input.stripe_instructions_7' => 'In the Endpoint URL field, add your website\'s URL in this format: %s',
    'store.input.stripe_instructions_8' => 'In the Events to send field, select the checkout.session.completed and click the Add endpoint button.',
    'store.input.stripe_instructions_9' => 'Copy the Signing secret key and paste it here accordingly.',
    'store.input.mollie' => 'Mollie',
    'store.input.mollie_is_enabled' => 'Enable Mollie payments',
    'store.input.mollie_api_key' => 'API Key',
    'store.input.mollie_instructions_1' => 'Go to <a href="https://my.mollie.com/dashboard">Mollie Dashboard</a> and Login to your account..',
    'store.input.mollie_instructions_2' => 'Go to Developers -> API Keys page.',
    'store.input.mollie_instructions_3' => 'Copy the API key and paste them here accordingly.',
    'store.input.offline_payment' => 'Offline payments',
    'store.input.offline_payment_is_enabled' => 'Enable cash on hand / card terminal payments',

    'store.input.business.header' => 'Business Details',
    'store.input.business.subheader' => 'These details will be used when generating invoices for the customer and for you.',
    'store.input.business.invoice_is_enabled' => 'Enable Invoices System',
    'store.input.business.invoice_is_enabled_help' => 'This option will determine if users will be able to see invoices for their payments or not.',
    'store.input.business.invoice_nr_prefix' => 'Invoice Nr Prefix',
    'store.input.business.invoice_nr_prefix_help' => 'Your Nr Prefix for all the invoices generated on the system. Ex: INV-',
    'store.input.business.name' => 'Name',
    'store.input.business.address' => 'Address',
    'store.input.business.county' => 'County',
    'store.input.business.zip' => 'ZIP',
    'store.input.business.email' => 'Email',
    'store.input.business.phone' => 'Phone',
    'store.input.business.tax_type' => 'Tax Type',
    'store.input.business.tax_type_placeholder' => 'ex: VAT',
    'store.input.business.tax_id' => 'Tax ID',
    'store.input.business.custom_key_one' => 'Custom Field Name',
    'store.input.business.custom_value_one' => 'Custom Field Value',
    'store.input.business.custom_key_two' => 'Custom Field Name',
    'store.input.business.custom_value_two' => 'Custom Field Value',
    'store.input.address' => 'Address',
    'store.input.address_help' => 'Full address of your store.',
    'store.input.phone' => 'Phone number',
    'store.input.phone_placeholder' => '',
    'store.input.website' => 'Website',
    'store.input.website_placeholder' => 'https://yourwebsite.com/',
    'store.input.email' => 'Email',
    'store.input.email_placeholder' => 'name@email.com',
    'store.input.password_help' => 'Require visitors to enter a password to see the content of the store.',
    'store.input.currency' => 'Currency',
    'store.input.currency_help' => 'Main currency code of the store. For Stripe & Paypal payments to work, you must introduce a valid currency code that they support (ex: EUR, USD, GBP).',
    'store.input.timezone' => 'Timezone',
    'store.input.timezone_help' => 'Main timezone of the store.',
    'store.input.hours' => 'Open hours',
    'store.input.hours_help' => 'Write in your business hours. Ex: 10:00 AM - 10:00 PM, 24/7...',
    'store.input.hours_end' => 'End hours',
    'store.input.is_enabled' => 'Store is enabled',
    'store.input.is_enabled_help' => 'The main switch that makes the store keep working.',
    'store.input.is_se_visible' => 'Search Engine visibility',
    'store.input.is_se_visible_help' => 'If disabled, the store will not be indexed by search engines, such as Google or Bing.',
    'store.input.is_removed_branding' => 'Remove branding',
    'store.input.is_removed_branding_help' => 'If enabled, the store won\'t show the branding of our website.',
    'store.input.facebook' => 'Facebook',
    'store.input.facebook_placeholder' => 'your-facebook-page-name',
    'store.input.x' => 'X',
    'store.input.x_placeholder' => 'your-x-username',
    'store.input.instagram' => 'Instagram',
    'store.input.instagram_placeholder' => 'your-instagram-username',
    'store.input.font_family' => 'Font family',
    'store.input.font_size' => 'Font size',
    'store.input.opengraph' => 'Opengraph image',
    'store.input.meta_description' => 'Meta description',
    'store.input.meta_description_help' => 'Set a custom meta description to rank better in search engines.',
    'store.input.meta_keywords' => 'Meta keywords',

    'store.error_message.url_exists' => 'This custom URL already exists.',
    'store.error_message.url_minimum_characters' => 'This custom URL is too small. Make sure it has at least %s characters.',
    'store.error_message.url_maximum_characters' => 'This custom URL is too big. Make sure it has maximum %s characters.',
    'store.no_data' => 'There are no created menus for this store',
    'store.no_data_help' => 'Start by creating your first menu.',


    'store_create.breadcrumb' => 'Create store',
    'store_create.title' => 'Create store',
    'store_create.header' => 'Create a new store',
    'store_create.info' => 'You can set up more details about the store after the creation.',


    'store_update.breadcrumb' => 'Edit store',
    'store_update.title' => '%s - Edit store',
    'store_update.main' => 'Main',
    'store_update.ordering' => 'Ordering',
    'store_update.business' => 'Business details',
    'store_update.customizations' => 'Customizations',
    'store_update.socials' => 'Socials',
    'store_update.advanced' => 'Advanced',
    'store_update.seo' => 'Seo',


    'store_qr.breadcrumb' => 'Store QR',
    'store_qr.title' => '%s - Store QR code',
    'store_qr.menu' => 'QR Code',
    'store_qr.header' => '%s store QR code',
    'store_qr.subheader' => 'This QR code is meant to be downloaded, printed and placed onto where your store customers can see and access it.',

    'store_qr.configurator.header' => 'QR Configurator',
    'store_qr.configurator.foreground_color' => 'Foreground color',
    'store_qr.configurator.background_color' => 'Background color',
    'store_qr.configurator.corner_radius' => 'Corner radius',
    'store_qr.configurator.type' => 'QR Type',
    'store_qr.configurator.type_normal' => 'Normal',
    'store_qr.configurator.type_text' => 'Insert custom text',
    'store_qr.configurator.type_image' => 'Insert custom logo',
    'store_qr.configurator.text' => 'Custom text',
    'store_qr.configurator.text_color' => 'Text color',
    'store_qr.configurator.text_size' => 'Text size',
    'store_qr.configurator.image' => 'Image',
    'store_qr.configurator.image_size' => 'Image size',
    'store_qr.configurator.ecc' => 'Error correction capability',
    'store_qr.configurator.ecc_l' => 'L - low (7%)',
    'store_qr.configurator.ecc_m' => 'M - medium (15%)',
    'store_qr.configurator.ecc_q' => 'Q - high (25%)',
    'store_qr.configurator.ecc_h' => 'H - best (30%)',
    'store_qr.print' => 'Print',
    'store_qr.success_message' => 'Your store has been updated with the new settings!',


    'orders.breadcrumb' => 'Store orders',
    'orders.title' => '(%1$s pending orders) - Store orders - %2$s',
    'orders.menu' => 'Orders',
    'orders.header' => '%s store orders',
    'orders.subheader' => 'Leave this page open to see and receive orders from your customers.',
    'orders.view' => 'Order #%s',
    'orders.name' => 'Name: %s',
    'orders.price_currency' => 'Price: %1$s %2$s',
    'orders.datetime' => 'Created on %s',
    'orders.processor' => 'Processor: %s',
    'orders.is_paid' => 'Is paid: %s',
    'orders.ordered_items' => 'Ordered items: %s',
    'orders.no_data' => 'There are no orders for now',
    'orders.no_data_help' => '',

    'order.breadcrumb' => 'Order',
    'order.title' => 'Order #%1$s - %2$s',
    'order.menu' => 'Order',
    'order.header' => 'Order #%s',
    'order.price' => 'Price',
    'order.datetime' => 'Date',
    'order.name' => 'Name',
    'order.number' => 'Number',
    'order.phone' => 'Phone',
    'order.address' => 'Address',
    'order.message' => 'Message',
    'order.total' => 'Total',
    'order.quantity' => 'Quantity: %s',
    'order.status_pending' => 'Pending',
    'order.status_complete' => 'Done',
    'order.is_paid' => 'Paid',
    'order.ordered_items' => 'Ordered items',
    'order.processor' => 'Processor',
    'order.processor_paypal' => 'PayPal',
    'order.processor_offline_payment' => 'Cash on hand/ Card at terminal',
    'order.processor_stripe' => 'Stripe',
    'order.processor_mollie' => 'Mollie',
    'order.type' => 'Type',
    'order.type_on_premise' => 'On premise',
    'order.type_takeaway' => 'Takeaway',
    'order.type_delivery' => 'Delivery',
    'order.delete' => 'Delete order',
    'order.finish' => 'Finish order',
    'order.success_message_complete' => 'The order status has been changed to completed!',


    'menus.title' => 'Menus',
    'menu.breadcrumb' => 'Menu',
    'menu.title' => 'Menu - %s',
    'menu.menu' => 'Menu',
    'menu.header' => '%s menu',
    'menu.create' => 'Create menu',
    'menu.external_url' => 'View menu',
    'menu.menus' => 'Menus',
    'menu.datetime' => 'Created on %s',
    'menu.pageviews' => '%s Pageviews',

    'menu.input.url' => 'URL Alias',
    'menu.input.url_placeholder' => 'menu-name',
    'menu.input.url_help' => 'The menu URL that your menu is going to be able accessed from.',
    'menu.input.name' => 'Name',
    'menu.input.name_placeholder' => 'My awesome menu',
    'menu.input.description' => 'Description',
    'menu.input.description_help' => 'Short description of your menu.',
    'menu.input.image' => 'Cover',
    'menu.input.is_enabled' => 'Menu is enabled',
    'menu.input.is_enabled_help' => 'Easily enable or disable the menu completely.',

    'menu.error_message.url_exists' => 'This menu already exists. Please choose a new one!',
    'menu.no_data' => 'There are no created categories for this menu',
    'menu.no_data_help' => 'Start by creating your first category.',

    'menu_create.breadcrumb' => 'Create menu',
    'menu_create.title' => 'Create menu',
    'menu_create.header' => 'Create a new menu',

    'menu_update.breadcrumb' => 'Edit menu',
    'menu_update.title' => 'Edit menu - %s',


    'categories.title' => 'Categories',
    'category.breadcrumb' => 'Category',
    'category.title' => 'Category - %s',
    'category.menu' => 'Category',
    'category.header' => '%s category',
    'category.create' => 'Create category',
    'category.external_url' => 'View category',
    'category.categories' => 'Categories',
    'category.datetime' => 'Created on %s',
    'category.pageviews' => '%s Pageviews',

    'category.input.url' => 'URL Alias',
    'category.input.url_placeholder' => 'category-name',
    'category.input.url_help' => 'The category URL that your category is going to be able accessed from.',
    'category.input.name' => 'Name',
    'category.input.name_placeholder' => 'My awesome category',
    'category.input.description' => 'Description',
    'category.input.description_help' => 'Short description of your category.',
    'category.input.is_enabled' => 'Category is enabled',
    'category.input.is_enabled_help' => 'Easily enable or disable the category completely.',

    'category.error_message.url_exists' => 'This category already exists. Please choose a new one!',
    'category.no_data' => 'There are no created items for this category',
    'category.no_data_help' => 'Start by creating your first item.',

    'category_create.breadcrumb' => 'Create category',
    'category_create.title' => 'Create category',
    'category_create.header' => 'Create a new category',

    'category_update.breadcrumb' => 'Edit category',
    'category_update.title' => 'Edit category - %s',


    'items.title' => 'Items',
    'item.breadcrumb' => 'Item',
    'item.title' => 'Item - %s',
    'item.menu' => 'Item',
    'item.header' => '%s item',
    'item.create' => 'Create item',
    'item.external_url' => 'View item',
    'item.items' => 'Items',
    'item.price_currency' => '%1$s %2$s',
    'item.datetime' => 'Created on %s',
    'item.orders' => '%s orders',
    'item.pageviews' => '%s Pageviews',

    'item.input.url' => 'URL Alias',
    'item.input.url_placeholder' => 'item-name',
    'item.input.url_help' => 'The item URL that your item is going to be able accessed from.',
    'item.input.name' => 'Name',
    'item.input.name_placeholder' => 'My awesome item',
    'item.input.description' => 'Description',
    'item.input.description_help' => 'Short description of your item.',
    'item.input.image' => 'Image',
    'item.input.price' => 'Price',
    'item.input.variants_is_enabled' => 'Variants',
    'item.input.variants_is_enabled_help' => 'Enable the ability to have multiple prices on this product based on variants that you create.',
    'item.input.is_enabled' => 'Item is enabled',
    'item.input.is_enabled_help' => 'Easily enable or disable the item completely.',

    'item.error_message.url_exists' => 'This item already exists. Please choose a new one!',

    'item_create.breadcrumb' => 'Create item',
    'item_create.title' => 'Create item',
    'item_create.header' => 'Create a new item',

    'item_update.breadcrumb' => 'Edit item',
    'item_update.title' => 'Edit item - %s',

    'item_extra.breadcrumb' => 'Item extra',
    'item_extra.create' => 'Create item extra',
    'item_extra.item_extras' => 'Item extras',
    'item_extra.datetime' => 'Created on %s',
    'item_extra.price_currency' => '%1$s %2$s',

    'item_extra.input.name' => 'Name',
    'item_extra.input.name_placeholder' => 'My awesome item extra',
    'item_extra.input.description' => 'Description',
    'item_extra.input.description_help' => 'Short description of your item extra.',
    'item_extra.input.price' => 'Price',
    'item_extra.input.is_enabled' => 'Item extra is enabled',
    'item_extra.input.is_enabled_help' => 'Easily enable or disable the item extra completely.',
    'item_extra.no_data' => 'There are no created item extras for this item',
    'item_extra.no_data_help' => 'Start by creating your first item extra.',

    'item_extra_create.breadcrumb' => 'Create item extra',
    'item_extra_create.title' => 'Create item extra',
    'item_extra_create.header' => 'Create a new item extra',

    'item_extra_update.breadcrumb' => 'Edit item extra',
    'item_extra_update.title' => 'Edit item extra -  %s',


    'item_option.breadcrumb' => 'Item option',
    'item_option.header' => '%s item option',
    'item_option.create' => 'Create item option',
    'item_option.item_options' => 'Item options',
    'item_option.datetime' => 'Created on %s',
    'item_option.options' => 'Options: %s',

    'item_option.input.name' => 'Name',
    'item_option.input.name_placeholder' => 'My awesome item option',
    'item_option.input.options' => 'Options',
    'item_option.input.options_placeholder' => 'Ex: small, medium, large.',
    'item_option.input.options_help' => 'Enter comma separated values.',
    'item_option.no_data' => 'There are no created item options for this item',
    'item_option.no_data_help' => 'Start by creating your first item option.',

    'item_option_create.breadcrumb' => 'Create item option',
    'item_option_create.title' => 'Create item option',
    'item_option_create.header' => 'Create a new item option',
    'item_option_create.success_message' => 'Your new item option has been created and is now ready!',

    'item_option_update.breadcrumb' => 'Edit item option',
    'item_option_update.title' => 'Edit item option - %s',


    'item_variant.breadcrumb' => 'Item variant',
    'item_variant.header' => 'Item variant - %s',
    'item_variant.create' => 'Create item variant',
    'item_variant.item_variants' => 'Item variants',
    'item_variant.datetime' => 'Created on %s',
    'item_variant.price_currency' => '%1$s %2$s',

    'item_variant.input.price' => 'Price',
    'item_variant.input.is_enabled' => 'Item variant is enabled',
    'item_variant.input.is_enabled_help' => 'Easily enable or disable the item variant completely.',
    'item_variant.no_data' => 'There are no created item variants for this item',
    'item_variant.no_data_help' => 'Start by creating your first item variant.',

    'item_variant_create.breadcrumb' => 'Create item variant',
    'item_variant_create.title' => 'Create item variant',
    'item_variant_create.header' => 'Create a new item variant',

    'item_variant_update.breadcrumb' => 'Edit item variant',
    'item_variant_update.title' => 'Edit item variant',
    'item_variant_update.header' => 'Edit item variant',

    'index.breadcrumb' => 'Home',
    'index.menu' => 'Home',
    'index.title' => 'Contactless QR Menus',
    'index.meta_description' => '',
    'index.meta_keywords' => '',
    'index.header' => 'Hi, Culinary Dynamo',
    'index.subheader' => 'Showcase your menu effortlessly',
    'index.button' => 'Get started',

    'index.feature.one' => 'Real-time changes',
    'index.feature.two' => 'No mobile app required',
    'index.feature.three' => 'Analytics included',

    'index.example.header' => 'Check out an example',
    'index.example.subheader' => 'Simply scan the following QR code with your phone.',
    'index.example.button' => 'View example menu',

    'index.demo.header' => 'Your store menu up and running, %sasap%s!',
    'index.demo.one' => 'Create & configure your store',
    'index.demo.two' => 'Print your store QR code',
    'index.demo.three' => 'Display the QR at your store',

    'index.extras_options_variants.name' => 'Item variations',
    'index.extras_options_variants.header' => 'Item extras, options & variants',
    'index.extras_options_variants.subheader' => 'Easily build the perfect item combinations.',

    'index.lightweight.name' => 'Performant store pages',
    'index.lightweight.header' => 'Fast, lightweight & minimal',
    'index.lightweight.subheader' => 'All your stores get a nice looking & lightweight design at fast speeds.',

    'index.analytics.name' => 'Analytics',
    'index.analytics.header' => 'Ready to go analytics',
    'index.analytics.subheader' => 'All your stores get proper analytics, day by day.',

    'index.pricing.header' => 'Choose your plan',
    'index.pricing.subheader' => 'Ready to start?',

    'index.cta.header' => 'Get started',
    'index.cta.subheader' => 'Easily manage all your store menus online and share them via QR.',
    'index.cta.pricing' => 'Pricing',
    'index.cta.register' => 'Sign up',

    'index.testimonials.header' => 'Here\'s what people are saying',
    'index.testimonials.one.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.Ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.one.name' => 'Andrea',
    'index.testimonials.one.attribute' => 'Writer Magazine',
    'index.testimonials.two.text' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Praesent finibus vestibulum porta. Sed id eros quam. Nunc at nisi vel arcu placerat gravida.',
    'index.testimonials.two.name' => 'George',
    'index.testimonials.two.attribute' => 'Lorem Ipsum Founder',
    'index.testimonials.three.text' => 'Praesent finibus vestibulum porta. Sed id eros quam. Proin lacinia ipsum porttitor, sollicitudin est in, ornare ex. Vivamus eu ex non orci condimentum placerat ac ac nisi. Nam velit libero, hendrerit vitae auctor eget, congue ut ante.',
    'index.testimonials.three.name' => 'Calvin',
    'index.testimonials.three.attribute' => 'SAAS Lorem Owner',

    'index.faq.header' => '%1$sAnswers%2$s for your common %1$squestions%2$s',
    'index.faq.one.question' => 'How do you edit this?',
    'index.faq.one.answer' => 'All the FAQ section can be edited from the admin panel - languages section.',
    'index.faq.two.question' => 'Lorem ipsum dolor sit amet',
    'index.faq.two.answer' => 'Lorem ipsum dolor sit amet, vim eu quem nonumes omittam. Mutat facete patrioque et est, nusquam abhorreant definiebas te sit, albucius urbanitas pro ad. Ne nemore officiis sed. Cu mundi docendi qui, nam nonumes maluisset constituto an, vix ea solum accusamus consequuntur.',
    'index.faq.three.question' => 'Virtute feugiat ocurreret ad cum',
    'index.faq.three.answer' => 'Virtute feugiat ocurreret ad cum, pro in posse ullum adversarium, te qui stet graece antiopam. Amet omnesque indoctum ut mel, ea eam sonet saperet nostrum. Te modus delectus mel, pri populo definitionem ne, an eam hinc labitur inciderint. Novum vivendum gloriatur ex nec, ad vocibus eleifend deterruisset pro, mutat voluptaria repudiandae eum ea. Ipsum soluta cotidieque sea ut, aliquando scripserit no has, iisque impetus erroribus pro ad. Case labitur scaevola vis ut, clita meliore te eos.',
    'index.faq.four.question' => 'Mel iusto putant feugiat et',
    'index.faq.four.answer' => 'Mel iusto putant feugiat et, qui alii virtute eu. Diceret corrumpit mei an. Ius ei congue iudico, ex quo delectus indoctum. Mnesarchum reprehendunt pro ex, ea vix amet maluisset, in autem omnes consectetuer eum.',


    'api.error_message.no_bearer' => 'The request is missing the Bearer Authentication header.',
    'api.error_message.no_access' => 'You do not have access to the API.',
    'api.error_message.rate_limit' => 'You reached the limit of requests in one minute, please wait.',
    'api.error_message.not_found' => 'The resource you are looking for does not exist.',


    'api_documentation.menu' => 'API Documentation',
    'api_documentation.breadcrumb' => 'API Documentation',
    'api_documentation.title' => 'API Documentation',
    'api_documentation.title_dynamic' => '%s - API Documentation',
    'api_documentation.header' => 'API Documentation',
    'api_documentation.subheader' => 'This is the documentation for the available API endpoints, which are built around the <strong>REST architecture</strong>. All the API endpoints will return a <strong>JSON response</strong> with the standard <strong>HTTP response codes</strong> and need a <strong>Bearer Authentication via an API Key</strong>.',
    'api_documentation.endpoint' => 'Endpoint',
    'api_documentation.example' => 'Example',
    'api_documentation.response' => 'Response example',
    'api_documentation.api_key' => 'API Key',
    'api_documentation.base_url' => 'Base URL',
    'api_documentation.parameters' => 'Parameters',
    'api_documentation.required' => 'Required',
    'api_documentation.optional' => 'Optional',
    'api_documentation.string' => 'String',
    'api_documentation.int' => 'Integer',
    'api_documentation.float' => 'Float',
    'api_documentation.boolean' => 'Boolean',
    'api_documentation.file' => 'File',
    'api_documentation.array' => 'Array',
    'api_documentation.read_all' => 'Retrieve all',
    'api_documentation.read' => 'Retrieve one',
    'api_documentation.create' => 'Create',
    'api_documentation.update' => 'Update',
    'api_documentation.delete' => 'Delete',
    'api_documentation.allowed_values' => 'Allowed values: %s',

    'api_documentation.authentication.header' => 'Authentication',
    'api_documentation.authentication.subheader' => 'All the API endpoints require an API key sent by the <strong>Bearer Authentication method.</strong>',

    'api_documentation.filters.page' => 'The page number that you want results from. Defaults to <code>1</code>.',
    'api_documentation.filters.results_per_page' => 'How many results you want per page. Allowed values are: %1$s. Defaults to <code>%2$s</code>.',
    'api_documentation.filters.search' => 'The search string.',
    'api_documentation.filters.search_by' => 'What field are you searching by. Allowed values are: %s.',
    'api_documentation.filters.order_by' => 'What field to order the results by. Allowed values are: %s.',
    'api_documentation.filters.order_by_type' => 'The ordering of the results. Allowed values are: <code>ASC</code> for ascending ordering, and <code>DESC</code> for descending ordering.',

    'api_documentation.teams' => 'Teams',
    'api_documentation.team_members' => 'Team members',
    'api_documentation.teams_member' => 'Teams member',
    'api_documentation.user' => 'User',
    'api_documentation.domains' => 'Custom domains',
    'api_documentation.payments' => 'Payments',
    'api_documentation.users_logs' => 'Logs',


    'contact.breadcrumb' => 'Contact',
    'contact.title' => 'Contact',
    'contact.menu' => 'Contact',
    'contact.header' => 'Contact us',
    'contact.subheader' => 'Get in touch with us via email.',
    'contact.input.email' => 'Email address',
    'contact.input.name' => 'Full name',
    'contact.input.subject' => 'Subject',
    'contact.input.message' => 'Message',
    'contact.success_message' => 'Your message was sent! We\'ll get back to you shortly.',


    'internal_notifications.breadcrumb' => 'Notifications',
    'internal_notifications.title' => 'Notifications',
    'internal_notifications.menu' => 'Notifications',
    'internal_notifications.header' => 'Notifications',
    'internal_notifications.subheader' => 'All your recent account related notifications.',
    'internal_notifications.no_data' => 'No notifications available',


    'affiliate.breadcrumb' => 'Affiliate',
    'affiliate.title' => 'Affiliate',
    'affiliate.menu' => 'Affiliate',
    'affiliate.header' => 'The affiliates program',
    'affiliate.subheader' => 'Easiest way to earn commission from people that you bring to the platform.',

    'affiliate.commission_percentage.header' => 'Variable commission',
    'affiliate.commission_percentage.subheader_once' => 'Earn commission from the first payment of any user that you bring to the platform.',
    'affiliate.commission_percentage.subheader_forever' => 'Earn commission from all of the payments of any user that you bring to the platform.',

    'affiliate.minimum_withdrawal_amount.header' => '%s minimum withdrawal',
    'affiliate.minimum_withdrawal_amount.subheader' => 'Once your approved balance reaches the minimum withdrawal amount, you can request a withdrawal.',

    'affiliate.how.header' => 'How does it work?',
    'affiliate.how.one' => 'Sign up',
    'affiliate.how.one_help' => 'Simply register for an account on our platform.',
    'affiliate.how.two' => 'Share your link',
    'affiliate.how.two_help' => 'Start promoting your referral link and bring new users.',
    'affiliate.how.three' => 'Start earning',
    'affiliate.how.three_help' => 'Once your referred users start paying, you\'ll get paid as well.',
    'affiliate.how.four' => 'Withdraw your money',
    'affiliate.how.four_help' => 'Request a withdrawal and you\'ll get paid.',

    'affiliate.cta.header' => 'Start earning money 💰',
    'affiliate.cta.subheader' => 'Create an account and start in just a few minutes.',
    'affiliate.cta.register' => 'Sign up',


    'notfound.title' => 'Not found',
    'notfound.header' => 'Page not found',
    'notfound.subheader' => 'Sorry, we couldn\'t find the page you\'re looking for.',
    'notfound.button' => 'Go back home',


    'cron.email_reports.title' => 'Summary analytics for %1$s between %2$s and %3$s',
    'cron.email_reports.p1' => 'Here is a short analytics overview of what happened on the %s store.',
    'cron.email_reports.pageviews' => 'Pageviews',
    'cron.email_reports.button' => 'Go to my dashboard',
    'cron.email_reports.notice' => 'You are getting these emails because you have enabled email reports in your %sStore settings%s page.',

];
